/*
 * Decompiled with CFR 0.152.
 */
package io.cortical.services.api.client;

import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.type.CollectionType;
import com.sun.jersey.api.client.Client;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.WebResource;
import com.sun.jersey.api.client.filter.ClientFilter;
import com.sun.jersey.api.client.filter.LoggingFilter;
import io.cortical.services.api.client.ApiException;
import io.cortical.services.api.client.JsonUtil;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.ws.rs.core.Response;
import org.apache.commons.httpclient.URIException;
import org.apache.commons.httpclient.util.URIUtil;

public class ApiInvoker {
    private static ApiInvoker INSTANCE = new ApiInvoker();
    private Map<String, Client> hostMap = new HashMap<String, Client>();
    private Map<String, String> defaultHeaderMap = new HashMap<String, String>();

    public static ApiInvoker getInstance() {
        return INSTANCE;
    }

    public void addDefaultHeader(String key, String value) {
        this.defaultHeaderMap.put(key, value);
    }

    public String escapeString(String str) {
        return str;
    }

    public static Object deserialize(String json, String containerType, Class cls, NestedContent nestedContent) throws ApiException {
        try {
            if (("List".equals(containerType) || "Array".equals(containerType)) && nestedContent != null) {
                if (NestedContent.CONTEXT.equals((Object)nestedContent)) {
                    JavaType typeInfo = JsonUtil.getJsonMapper().getTypeFactory().constructFromCanonical("java.util.List<java.util.List<io.cortical.rest.model.Context>>");
                    Object response = JsonUtil.getJsonMapper().readValue(json, typeInfo);
                    return response;
                }
                if (NestedContent.TERM.equals((Object)nestedContent)) {
                    JavaType typeInfo = JsonUtil.getJsonMapper().getTypeFactory().constructFromCanonical("java.util.List<java.util.List<io.cortical.rest.model.Term>>");
                    Object response = JsonUtil.getJsonMapper().readValue(json, typeInfo);
                    return response;
                }
                return null;
            }
            if ("List".equals(containerType) || "Array".equals(containerType)) {
                CollectionType typeInfo = JsonUtil.getJsonMapper().getTypeFactory().constructCollectionType(List.class, cls);
                List response = (List)JsonUtil.getJsonMapper().readValue(json, (JavaType)typeInfo);
                return response;
            }
            if (String.class.equals((Object)cls)) {
                if (json != null && json.startsWith("\"") && json.endsWith("\"") && json.length() > 1) {
                    return json.substring(1, json.length() - 2);
                }
                return json;
            }
            return JsonUtil.getJsonMapper().readValue(json, cls);
        }
        catch (IOException e) {
            throw new ApiException(500, e.getMessage());
        }
    }

    public static String serialize(Object obj) throws ApiException {
        try {
            if (obj != null) {
                if (obj instanceof String) {
                    return (String)obj;
                }
                return JsonUtil.getJsonMapper().writeValueAsString(obj);
            }
            return null;
        }
        catch (Exception e) {
            throw new ApiException(500, e.getMessage());
        }
    }

    public Object invokeAPI(String host, String path, String method, Map<String, String> queryParams, Object body, Map<String, String> headerParams, String contentType) throws ApiException {
        Client client = this.getClient(host);
        StringBuilder b = new StringBuilder();
        for (String key : queryParams.keySet()) {
            String value = queryParams.get(key);
            if (value == null) continue;
            if (b.toString().length() == 0) {
                b.append("?");
            } else {
                b.append("&");
            }
            b.append(this.escapeString(key)).append("=").append(this.escapeString(value));
        }
        String querystring = b.toString();
        try {
            querystring = URIUtil.encodeQuery((String)querystring);
        }
        catch (URIException e) {
            throw new ApiException(0, e.getStackTrace().toString());
        }
        WebResource.Builder builder = client.resource(host + path + querystring).accept(new String[]{"application/json", "image/png"});
        for (String key : headerParams.keySet()) {
            builder.header(key, (Object)headerParams.get(key));
        }
        for (String key : this.defaultHeaderMap.keySet()) {
            if (headerParams.containsKey(key)) continue;
            builder.header(key, (Object)this.defaultHeaderMap.get(key));
        }
        ClientResponse response = null;
        if ("GET".equals(method)) {
            response = (ClientResponse)builder.get(ClientResponse.class);
        } else if ("POST".equals(method)) {
            response = body == null ? (ClientResponse)builder.post(ClientResponse.class, (Object)ApiInvoker.serialize(body)) : (ClientResponse)((WebResource.Builder)builder.type("application/json")).post(ClientResponse.class, (Object)ApiInvoker.serialize(body));
        } else if ("PUT".equals(method)) {
            response = body == null ? (ClientResponse)builder.put(ClientResponse.class, (Object)ApiInvoker.serialize(body)) : (ClientResponse)((WebResource.Builder)builder.type("application/json")).put(ClientResponse.class, (Object)ApiInvoker.serialize(body));
        } else if ("DELETE".equals(method)) {
            response = body == null ? (ClientResponse)builder.delete(ClientResponse.class, (Object)ApiInvoker.serialize(body)) : (ClientResponse)((WebResource.Builder)builder.type("application/json")).delete(ClientResponse.class, (Object)ApiInvoker.serialize(body));
        } else {
            throw new ApiException(500, "unknown method type " + method);
        }
        if (response.getClientResponseStatus() == ClientResponse.Status.NO_CONTENT) {
            return null;
        }
        if (response.getClientResponseStatus().getFamily() == Response.Status.Family.SUCCESSFUL) {
            if (!((String)((List)response.getHeaders().get((Object)"Content-Type")).get(0)).equals("application/json")) {
                return response.getEntityInputStream();
            }
            return (String)response.getEntity(String.class);
        }
        throw new ApiException(response.getClientResponseStatus().getStatusCode(), (String)response.getEntity(String.class));
    }

    private Client getClient(String host) {
        if (!this.hostMap.containsKey(host)) {
            Client client = Client.create();
            client.addFilter((ClientFilter)new LoggingFilter());
            this.hostMap.put(host, client);
        }
        return this.hostMap.get(host);
    }

    public static enum NestedContent {
        CONTEXT,
        TERM;

    }
}

