/*
 * Decompiled with CFR 0.152.
 */
package io.cortical.services;

import com.fasterxml.jackson.core.JsonProcessingException;
import io.cortical.rest.model.Fingerprint;
import io.cortical.rest.model.Model;
import io.cortical.rest.model.Retina;
import io.cortical.rest.model.Text;
import io.cortical.services.BaseRetinaApi;
import io.cortical.services.Pagination;
import io.cortical.services.PosTag;
import io.cortical.services.Texts;
import io.cortical.services.api.client.ApiException;
import io.cortical.services.api.client.api.TextApi;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

class TextRetinaApiImpl
extends BaseRetinaApi
implements Texts {
    private static final Log LOG = LogFactory.getLog(TextRetinaApiImpl.class);
    private final TextApi api;

    TextRetinaApiImpl(String apiKey, String basePath, String retinaName) {
        super(retinaName);
        if (StringUtils.isBlank((CharSequence)apiKey)) {
            throw new IllegalArgumentException("The apiKey cannot be null.");
        }
        if (StringUtils.isBlank((CharSequence)basePath)) {
            throw new IllegalArgumentException("The base path cannot be null.");
        }
        LOG.info((Object)("Initialize Text Retina Api with retina: " + retinaName));
        this.api = new TextApi(apiKey);
        this.api.setBasePath(basePath);
    }

    TextRetinaApiImpl(TextApi api, String retinaName) {
        super(retinaName);
        this.api = api;
    }

    @Override
    public List<String> getKeywords(String text) throws ApiException {
        if (StringUtils.isEmpty((CharSequence)text)) {
            throw new IllegalArgumentException("The text cannot be null.");
        }
        LOG.debug((Object)("Retrieve keywords for the text: " + text));
        return this.api.getKeywordsForText(text, this.retinaName);
    }

    @Override
    public List<Fingerprint> getFingerprints(String text) throws ApiException {
        if (StringUtils.isEmpty((CharSequence)text)) {
            throw new IllegalArgumentException("The text cannot be null.");
        }
        LOG.debug((Object)("Retrieve representation for the text: " + text));
        return this.api.getRepresentationForText(text, this.retinaName);
    }

    @Override
    public List<Fingerprint> getFingerprintBulk(Double sparsity, Text ... texts) throws JsonProcessingException, ApiException {
        this.validateRequiredModels((Model[])texts);
        LOG.debug((Object)("Retrieve representation for the bulk Text: " + this.toJson((Model[])texts) + "  sparsity: " + sparsity));
        return this.api.getRepresentationsForBulkText(this.toJson((Model[])texts), this.retinaName, sparsity);
    }

    @Override
    public List<Text> getSlices(String text, Pagination pagination, Boolean includeFingerprint) throws ApiException {
        if (StringUtils.isEmpty((CharSequence)text)) {
            throw new IllegalArgumentException("The text cannot be null.");
        }
        pagination = this.initPagination(pagination);
        LOG.debug((Object)("Retrieve slices for the text: " + text + " pagination: " + pagination.toString() + "  include fingerprint: " + includeFingerprint));
        return this.api.getSlicesForText(text, includeFingerprint, this.retinaName, pagination.getStartIndex(), pagination.getMaxResults());
    }

    @Override
    public List<String> getTokens(String text, PosTag[] posTags) throws ApiException {
        if (StringUtils.isEmpty((CharSequence)text)) {
            throw new IllegalArgumentException("The text cannot be null.");
        }
        LOG.debug((Object)("Retrieve tokens for the text: " + text));
        return this.api.getTokensForText(text, this.cluePosTags(posTags), this.retinaName);
    }

    private String cluePosTags(PosTag[] posTags) {
        if (posTags.length == 0) {
            return "";
        }
        StringBuilder cluedPosTags = new StringBuilder();
        cluedPosTags.append(posTags[0].getLabel());
        for (int i = 1; i < posTags.length; ++i) {
            cluedPosTags.append(",");
            cluedPosTags.append(posTags[i].getLabel());
        }
        return cluedPosTags.toString();
    }

    @Override
    public List<Text> getSlices(String text, Boolean includeFingerprint) throws ApiException {
        return this.getSlices(text, null, includeFingerprint);
    }

    @Override
    public List<Text> getSlices(String text) throws ApiException {
        return this.getSlices(text, null);
    }

    @Override
    public Retina identifyRetinaByText(String text) throws ApiException {
        if (StringUtils.isEmpty((CharSequence)text)) {
            throw new IllegalArgumentException("The text cannot be null.");
        }
        return this.api.getLanguage(text);
    }
}

