/*
 * Decompiled with CFR 0.152.
 */
package io.cortical.services;

import io.cortical.rest.model.Context;
import io.cortical.rest.model.Term;
import io.cortical.services.BaseRetinaApi;
import io.cortical.services.Pagination;
import io.cortical.services.PosType;
import io.cortical.services.Terms;
import io.cortical.services.api.client.ApiException;
import io.cortical.services.api.client.api.TermsApi;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

class TermsRetinaApiImpl
extends BaseRetinaApi
implements Terms {
    private static final Log LOG = LogFactory.getLog(TermsRetinaApiImpl.class);
    private final TermsApi api;

    TermsRetinaApiImpl(String apiKey, String basePath, String retinaName) {
        super(retinaName);
        if (StringUtils.isBlank((CharSequence)apiKey)) {
            throw new IllegalArgumentException("The apiKey cannot be null.");
        }
        if (StringUtils.isBlank((CharSequence)basePath)) {
            throw new IllegalArgumentException("The base path cannot be null.");
        }
        LOG.info((Object)("Initialize Terms Retina Api with retina: " + retinaName));
        this.api = new TermsApi(apiKey);
        this.api.setBasePath(basePath);
    }

    TermsRetinaApiImpl(TermsApi api, String retinaName) {
        super(retinaName);
        this.api = api;
    }

    @Override
    public List<Context> getContexts(String term, Pagination pagination, Boolean includeFingerprint) throws ApiException {
        pagination = this.initPagination(pagination);
        this.validateTerm(term);
        LOG.debug((Object)("Retrieve contexts for the term: " + term + " pagination: " + pagination.toString() + "  include fingerprint: " + includeFingerprint));
        return this.api.getContextsForTerm(term, includeFingerprint, this.retinaName, pagination.getStartIndex(), pagination.getMaxResults());
    }

    @Override
    public List<Term> getSimilarTerms(String term, Integer contextId, PosType posType, Pagination pagination, Boolean includeFingerprint) throws ApiException {
        pagination = this.initPagination(pagination);
        this.validateTerm(term);
        String posTypeName = null;
        if (posType != null) {
            posTypeName = posType.name();
        }
        LOG.debug((Object)("Retrieve Similar for the term: " + term + " pagination: " + pagination.toString() + "  include fingerprint: " + includeFingerprint));
        return this.api.getSimilarTerms(term, contextId, posTypeName, includeFingerprint, this.retinaName, pagination.getStartIndex(), pagination.getMaxResults());
    }

    @Override
    public List<Term> getTerm(String term, Pagination pagination, Boolean includeFingerprint) throws ApiException {
        pagination = this.initPagination(pagination);
        LOG.debug((Object)("Retrieve terms: " + term + " pagination: " + pagination.toString() + "  include fingerprint: " + includeFingerprint));
        return this.api.getTerm(term, includeFingerprint, this.retinaName, pagination.getStartIndex(), pagination.getMaxResults());
    }

    private void validateTerm(String term) {
        if (term == null || term.trim().length() == 0) {
            throw new IllegalArgumentException("The term cannot be null.");
        }
    }

    @Override
    public List<Context> getContexts(String term, Boolean includeFingerprint) throws ApiException {
        return this.getContexts(term, null, includeFingerprint);
    }

    @Override
    public List<Context> getContexts(String term) throws ApiException {
        return this.getContexts(term, null);
    }

    @Override
    public List<Term> getSimilarTerms(String term, Integer contextId, PosType posType, Boolean includeFingerprint) throws ApiException {
        return this.getSimilarTerms(term, contextId, posType, null, includeFingerprint);
    }

    @Override
    public List<Term> getSimilarTerms(String term, Integer contextId, PosType posType) throws ApiException {
        return this.getSimilarTerms(term, contextId, posType, null);
    }

    @Override
    public List<Term> getTerm(String term, Boolean includeFingerprint) throws ApiException {
        return this.getTerm(term, null, includeFingerprint);
    }

    @Override
    public List<Term> getTerm(String term) throws ApiException {
        return this.getTerm(term, null);
    }

    @Override
    public List<Term> getAllTerms(Pagination pagination) throws ApiException {
        return this.getTerm(null, pagination, null);
    }

    @Override
    public List<Term> getAllTerms(Pagination pagination, Boolean includeFingerprint) throws ApiException {
        return this.getTerm(null, pagination, includeFingerprint);
    }

    @Override
    public List<Term> getSimilarTerms(String term) throws ApiException {
        return this.getSimilarTerms(term, null, null);
    }
}

