/*
 * Decompiled with CFR 0.152.
 */
package io.cortical.services;

import io.cortical.services.Compare;
import io.cortical.services.CompareRetinaApiImpl;
import io.cortical.services.Expressions;
import io.cortical.services.ExpressionsRetinaApiImpl;
import io.cortical.services.ImageRetinaApiImpl;
import io.cortical.services.Images;
import io.cortical.services.RetinaApiUtils;
import io.cortical.services.RetinaInfoApiImpl;
import io.cortical.services.Retinas;
import io.cortical.services.Terms;
import io.cortical.services.TermsRetinaApiImpl;
import io.cortical.services.TextRetinaApiImpl;
import io.cortical.services.Texts;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class RetinaApis {
    private static final Log LOG = LogFactory.getLog(RetinaApis.class);
    private final Compare compareApi;
    private final Expressions expressionsApi;
    private final Images imageApi;
    private final Terms termsApi;
    private final Texts textApi;

    public RetinaApis(String retinaName, String ip, String apiKey) {
        String basePath = RetinaApiUtils.generateBasepath(ip, null);
        if (StringUtils.isEmpty((CharSequence)retinaName)) {
            throw new IllegalArgumentException("The retinaName cannot be null.");
        }
        if (StringUtils.isEmpty((CharSequence)apiKey)) {
            throw new IllegalArgumentException("The apiKey cannot be null.");
        }
        LOG.info((Object)("Initialize retina API for retina name: " + retinaName));
        this.compareApi = new CompareRetinaApiImpl(retinaName, basePath, apiKey);
        this.expressionsApi = new ExpressionsRetinaApiImpl(apiKey, basePath, retinaName);
        this.imageApi = new ImageRetinaApiImpl(apiKey, basePath, retinaName);
        this.termsApi = new TermsRetinaApiImpl(apiKey, basePath, retinaName);
        this.textApi = new TextRetinaApiImpl(apiKey, basePath, retinaName);
    }

    public RetinaApis(String retinaName, String ip, Short port, String apiKey) {
        String basePath = RetinaApiUtils.generateBasepath(ip, port);
        if (StringUtils.isEmpty((CharSequence)retinaName)) {
            throw new IllegalArgumentException("The retinaName cannot be null.");
        }
        if (StringUtils.isEmpty((CharSequence)apiKey)) {
            throw new IllegalArgumentException("The apiKey cannot be null.");
        }
        LOG.info((Object)("Initialize retina API for retina name: " + retinaName));
        this.compareApi = new CompareRetinaApiImpl(retinaName, basePath, apiKey);
        this.expressionsApi = new ExpressionsRetinaApiImpl(apiKey, basePath, retinaName);
        this.imageApi = new ImageRetinaApiImpl(apiKey, basePath, retinaName);
        this.termsApi = new TermsRetinaApiImpl(apiKey, basePath, retinaName);
        this.textApi = new TextRetinaApiImpl(apiKey, basePath, retinaName);
    }

    public final Compare compareApi() {
        return this.compareApi;
    }

    public final Expressions expressionsApi() {
        return this.expressionsApi;
    }

    public final Images imageApi() {
        return this.imageApi;
    }

    public final Terms termsApi() {
        return this.termsApi;
    }

    public final Texts textApi() {
        return this.textApi;
    }

    public static Retinas getInfo(String ip, String apiKey) {
        return new RetinaInfoApiImpl(ip, apiKey);
    }

    public static Retinas getInfo(String ip, Short port, String apiKey) {
        return new RetinaInfoApiImpl(ip, port, apiKey);
    }
}

