/*
 * Decompiled with CFR 0.152.
 */
package io.cortical.services;

import com.fasterxml.jackson.core.JsonProcessingException;
import io.cortical.rest.model.Metric;
import io.cortical.rest.model.Model;
import io.cortical.services.BaseRetinaApi;
import io.cortical.services.Compare;
import io.cortical.services.api.client.ApiException;
import io.cortical.services.api.client.api.CompareApi;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

class CompareRetinaApiImpl
extends BaseRetinaApi
implements Compare {
    private static final Log LOG = LogFactory.getLog(CompareRetinaApiImpl.class);
    private final CompareApi compareApi;

    CompareRetinaApiImpl(String retinaName, String basePath, String apiKey) {
        super(retinaName);
        if (StringUtils.isBlank((CharSequence)apiKey)) {
            throw new IllegalArgumentException("The apiKey cannot be null.");
        }
        if (StringUtils.isBlank((CharSequence)basePath)) {
            throw new IllegalArgumentException("The base path cannot be null.");
        }
        LOG.info((Object)("Initialize Compare Retina Api with retina: " + retinaName));
        this.compareApi = new CompareApi(apiKey);
        this.compareApi.setBasePath(basePath);
    }

    CompareRetinaApiImpl(CompareApi api, String retinaName) {
        super(retinaName);
        this.compareApi = api;
    }

    @Override
    public Metric compare(Model model1, Model model2) throws JsonProcessingException, ApiException {
        this.validateRequiredModels(model1, model2);
        LOG.debug((Object)("Compare models: model1: " + model1.toJson() + "  model: " + model2.toJson()));
        return this.compareApi.compare(this.toJson(model1, model2), this.retinaName);
    }

    @Override
    public Metric compare(String jsonModel1, Model model2) throws JsonProcessingException, ApiException {
        this.validateRequiredModels(model2);
        LOG.debug((Object)("Compare models: model1: " + jsonModel1 + "  model: " + model2.toJson()));
        return this.compareApi.compare("[ " + jsonModel1 + ", " + model2.toJson() + " ]", this.retinaName);
    }

    @Override
    public Metric compare(String jsonModel1, String jsonModel2) throws JsonProcessingException, ApiException {
        LOG.debug((Object)("Compare models: model1: " + jsonModel1 + "  model: " + jsonModel2));
        return this.compareApi.compare("[ " + jsonModel1 + ", " + jsonModel2 + " ]", this.retinaName);
    }
}

