/*
 * Decompiled with CFR 0.152.
 */
package io.cortical.services;

import com.fasterxml.jackson.core.JsonProcessingException;
import io.cortical.rest.model.Model;
import io.cortical.services.Pagination;
import org.apache.commons.lang3.StringUtils;

abstract class BaseRetinaApi {
    protected final String retinaName;

    protected BaseRetinaApi(String retinaName) {
        if (StringUtils.isBlank((CharSequence)retinaName)) {
            throw new IllegalArgumentException("The retinaName cannot be null.");
        }
        this.retinaName = retinaName;
    }

    protected void validateRequiredModels(Model ... models) {
        if (models == null || models.length == 0) {
            throw new IllegalArgumentException("The model cannot be null or empty.");
        }
        for (Model model : models) {
            if (model != null) continue;
            throw new IllegalArgumentException("The model cannot be null or empty.");
        }
    }

    protected Pagination initPagination(Pagination pagination) {
        if (pagination == null) {
            return new Pagination();
        }
        return pagination;
    }

    protected String toJson(Model ... models) throws JsonProcessingException {
        return Model.toJson((Model[])models);
    }
}

