/*
 * Decompiled with CFR 0.152.
 */
package io.cortical.retina.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Map;
import javax.xml.bind.annotation.XmlElement;

public class Metric {
    public static final String COSINE_SIMILARITY = "Cosine-Similarity";
    public static final String EUCLIDEAN_DISTANCE = "Euclidean-Distance";
    public static final String JACCARD_DISTANCE = "Jaccard-Distance";
    public static final String OVERLAPPING_ALL = "Overlapping-all";
    public static final String OVERLAPPING_LEFT_RIGHT = "Overlapping-left-right";
    public static final String OVERLAPPING_RIGHT_LEFT = "Overlapping-right-left";
    public static final String WEIGHTED_SCORING = "Weighted-Scoring";
    public static final String SIZE_LEFT = "Size-left";
    public static final String SIZE_RIGHT = "Size-right";
    private double cosineSimilarity;
    private double euclideanDistance;
    private double jaccardDistance;
    private int overlappingAll;
    private double overlappingLeftRight;
    private double overlappingRightLeft;
    private int sizeLeft;
    private int sizeRight;
    private double weightedScoring;

    public Metric() {
    }

    public Metric(Map<String, Double> resultMap) {
        this.cosineSimilarity = resultMap.get(COSINE_SIMILARITY);
        this.euclideanDistance = resultMap.get(EUCLIDEAN_DISTANCE);
        this.jaccardDistance = resultMap.get(JACCARD_DISTANCE);
        this.overlappingAll = resultMap.get(OVERLAPPING_ALL).intValue();
        this.overlappingLeftRight = resultMap.get(OVERLAPPING_LEFT_RIGHT);
        this.overlappingRightLeft = resultMap.get(OVERLAPPING_RIGHT_LEFT);
        this.sizeLeft = resultMap.get(SIZE_LEFT).intValue();
        this.sizeRight = resultMap.get(SIZE_RIGHT).intValue();
        this.weightedScoring = resultMap.get(WEIGHTED_SCORING);
    }

    @XmlElement(name="cosineSimilarity")
    @JsonProperty(value="cosineSimilarity")
    public double getCosineSimilarity() {
        return this.cosineSimilarity;
    }

    @XmlElement(name="euclideanDistance")
    @JsonProperty(value="euclideanDistance")
    public double getEuclideanDistance() {
        return this.euclideanDistance;
    }

    @XmlElement(name="jaccardDistance")
    @JsonProperty(value="jaccardDistance")
    public double getJaccardDistance() {
        return this.jaccardDistance;
    }

    @XmlElement(name="overlappingAll")
    @JsonProperty(value="overlappingAll")
    public int getOverlappingAll() {
        return this.overlappingAll;
    }

    @XmlElement(name="overlappingLeftRight")
    @JsonProperty(value="overlappingLeftRight")
    public double getOverlappingLeftRight() {
        return this.overlappingLeftRight;
    }

    @XmlElement(name="overlappingRightLeft")
    @JsonProperty(value="overlappingRightLeft")
    public double getOverlappingRightLeft() {
        return this.overlappingRightLeft;
    }

    @XmlElement(name="sizeLeft")
    @JsonProperty(value="sizeLeft")
    public int getSizeLeft() {
        return this.sizeLeft;
    }

    @XmlElement(name="sizeRight")
    @JsonProperty(value="sizeRight")
    public int getSizeRight() {
        return this.sizeRight;
    }

    @XmlElement(name="weightedScoring")
    @JsonProperty(value="weightedScoring")
    public double getWeightedScoring() {
        return this.weightedScoring;
    }

    protected void setCosineSimilarity(double cosineSimilarity) {
        this.cosineSimilarity = cosineSimilarity;
    }

    protected void setEuclideanDistance(double euclideanDistance) {
        this.euclideanDistance = euclideanDistance;
    }

    protected void setJaccardDistance(double jaccardDistance) {
        this.jaccardDistance = jaccardDistance;
    }

    protected void setOverlappingAll(int overlappingAll) {
        this.overlappingAll = overlappingAll;
    }

    protected void setOverlappingLeftRight(double overlappingLeftRight) {
        this.overlappingLeftRight = overlappingLeftRight;
    }

    protected void setOverlappingRightLeft(double overlappingRightLeft) {
        this.overlappingRightLeft = overlappingRightLeft;
    }

    protected void setSizeLeft(int sizeLeft) {
        this.sizeLeft = sizeLeft;
    }

    protected void setSizeRight(int sizeRight) {
        this.sizeRight = sizeRight;
    }

    protected void setWeightedScoring(double weightedScoring) {
        this.weightedScoring = weightedScoring;
    }
}

