/*
 * Decompiled with CFR 0.152.
 */
package io.cortical.retina.core;

import com.fasterxml.jackson.core.JsonProcessingException;
import io.cortical.retina.core.AbstractEndpoint;
import io.cortical.retina.core.ImageEncoding;
import io.cortical.retina.core.ImagePlotShape;
import io.cortical.retina.model.Image;
import io.cortical.retina.model.Model;
import io.cortical.retina.rest.ApiException;
import io.cortical.retina.rest.ImageApi;
import java.io.ByteArrayInputStream;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class Images
extends AbstractEndpoint {
    private final ImageApi api;

    Images(String apiKey, String basePath, String retinaName) {
        super(retinaName);
        if (StringUtils.isBlank((CharSequence)apiKey)) {
            throw new IllegalArgumentException("The apiKey cannot be null.");
        }
        if (StringUtils.isBlank((CharSequence)basePath)) {
            throw new IllegalArgumentException("The base path cannot be null.");
        }
        this.api = new ImageApi(apiKey);
        this.api.setBasePath(basePath);
    }

    Images(ImageApi api, String retinaName) {
        super(retinaName);
        this.api = api;
    }

    public ByteArrayInputStream getImage(Model model, int scalar, ImagePlotShape shape, ImageEncoding imageEncoding, double sparsity) throws JsonProcessingException, ApiException {
        String shapeString = null;
        if (shape != null) {
            shapeString = shape.name().toLowerCase();
        }
        String encodingString = null;
        if (imageEncoding != null) {
            encodingString = imageEncoding.machineRepresentation();
        }
        return this.api.getImageForExpression(model.toJson(), this.retinaName, scalar, shapeString, encodingString, sparsity);
    }

    public <T extends Model> List<Image> getImages(List<T> models, boolean includeFingerprint, int scalar, ImagePlotShape shape, double sparsity) throws JsonProcessingException, ApiException {
        String shapeString = null;
        if (shape != null) {
            shapeString = shape.name().toLowerCase();
        }
        return this.api.getImageForBulkExpressions(this.toJson(models), includeFingerprint, this.retinaName, scalar, shapeString, sparsity);
    }

    public <T extends Model> ByteArrayInputStream compareImage(List<T> models, int scalar, ImagePlotShape shape, ImageEncoding imageEncoding) throws JsonProcessingException, ApiException {
        String shapeString = null;
        if (shape != null) {
            shapeString = shape.name().toLowerCase();
        }
        String encodingString = null;
        if (imageEncoding != null) {
            encodingString = imageEncoding.machineRepresentation();
        }
        return this.api.getOverlayImage(this.toJson(models), this.retinaName, shapeString, scalar, encodingString);
    }
}

