/*
 * Decompiled with CFR 0.152.
 */
package io.cortical.retina.core;

import io.cortical.retina.core.Classify;
import io.cortical.retina.core.Compare;
import io.cortical.retina.core.Expressions;
import io.cortical.retina.core.Images;
import io.cortical.retina.core.Terms;
import io.cortical.retina.core.Texts;
import io.cortical.retina.model.Retina;
import io.cortical.retina.rest.ApiException;
import io.cortical.retina.rest.RetinasApi;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class Endpoints {
    private final Compare compareApi;
    private final Expressions expressionsApi;
    private final Images imageApi;
    private final Terms termsApi;
    private final Texts textApi;
    private final Classify classifyApi;
    private final RetinasApi retinasApi;

    public Endpoints(String retinaName, String basePath, String apiKey) {
        if (StringUtils.isEmpty((CharSequence)retinaName)) {
            throw new IllegalArgumentException("The retinaName cannot be null.");
        }
        if (StringUtils.isEmpty((CharSequence)apiKey)) {
            throw new IllegalArgumentException("The apiKey cannot be null.");
        }
        this.compareApi = new Compare(retinaName, basePath, apiKey);
        this.expressionsApi = new Expressions(apiKey, basePath, retinaName);
        this.imageApi = new Images(apiKey, basePath, retinaName);
        this.termsApi = new Terms(apiKey, basePath, retinaName);
        this.textApi = new Texts(apiKey, basePath, retinaName);
        this.classifyApi = new Classify(apiKey, basePath, retinaName);
        this.retinasApi = new RetinasApi(apiKey);
    }

    public Endpoints(String retinaName, String protocol, String ip, int port, String path, String apiKey) {
        String basePath = Endpoints.generateBasepath(protocol, ip, port, path);
        if (StringUtils.isEmpty((CharSequence)retinaName)) {
            throw new IllegalArgumentException("The retinaName cannot be null.");
        }
        if (StringUtils.isEmpty((CharSequence)apiKey)) {
            throw new IllegalArgumentException("The apiKey cannot be null.");
        }
        this.compareApi = new Compare(retinaName, basePath, apiKey);
        this.expressionsApi = new Expressions(apiKey, basePath, retinaName);
        this.imageApi = new Images(apiKey, basePath, retinaName);
        this.termsApi = new Terms(apiKey, basePath, retinaName);
        this.textApi = new Texts(apiKey, basePath, retinaName);
        this.classifyApi = new Classify(apiKey, basePath, retinaName);
        this.retinasApi = new RetinasApi(apiKey);
    }

    public Compare compareApi() {
        return this.compareApi;
    }

    public Expressions expressionsApi() {
        return this.expressionsApi;
    }

    public Images imageApi() {
        return this.imageApi;
    }

    public Terms termsApi() {
        return this.termsApi;
    }

    public Texts textApi() {
        return this.textApi;
    }

    public Classify classifyApi() {
        return this.classifyApi;
    }

    public List<Retina> getAllRetinas() throws ApiException {
        return this.retinasApi.getRetinas(null);
    }

    public Retina retinaByName(String name) throws ApiException {
        List<Retina> retinas = this.retinasApi.getRetinas(name);
        if (retinas == null || retinas.size() == 0) {
            return null;
        }
        return retinas.get(0);
    }

    public static String generateBasepath(String protocol, String ip, int port, String path) {
        if (StringUtils.isEmpty((CharSequence)ip)) {
            throw new IllegalArgumentException("The retina server ip cannot be null.");
        }
        if (port == -1) {
            port = 80;
        }
        StringBuilder basePath = new StringBuilder();
        basePath.append(protocol).append(ip).append(":").append(port).append(path);
        return basePath.toString();
    }

    static Endpoints makeTestRetinas(RetinasApi api) {
        return new Endpoints(api);
    }

    private Endpoints(RetinasApi api) {
        this.compareApi = null;
        this.expressionsApi = null;
        this.imageApi = null;
        this.termsApi = null;
        this.textApi = null;
        this.classifyApi = null;
        this.retinasApi = api;
    }
}

