/*
 * Decompiled with CFR 0.152.
 */
package io.cortical.retina.core;

import com.fasterxml.jackson.core.JsonProcessingException;
import io.cortical.retina.core.AbstractEndpoint;
import io.cortical.retina.model.Metric;
import io.cortical.retina.model.Model;
import io.cortical.retina.rest.ApiException;
import io.cortical.retina.rest.CompareApi;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class Compare
extends AbstractEndpoint {
    private final CompareApi compareApi;

    Compare(String retinaName, String basePath, String apiKey) {
        super(retinaName);
        if (StringUtils.isBlank((CharSequence)apiKey)) {
            throw new IllegalArgumentException("The apiKey cannot be null.");
        }
        if (StringUtils.isBlank((CharSequence)basePath)) {
            throw new IllegalArgumentException("The base path cannot be null.");
        }
        this.compareApi = new CompareApi(apiKey);
        this.compareApi.setBasePath(basePath);
    }

    Compare(CompareApi api, String retinaName) {
        super(retinaName);
        this.compareApi = api;
    }

    public Metric compare(Model model1, Model model2) throws JsonProcessingException, ApiException {
        this.validateRequiredModels(model1, model2);
        return this.compareApi.compare(this.toJson(model1, model2), this.retinaName);
    }

    public Metric[] compareBulk(List<CompareModel> compareModels) throws JsonProcessingException, ApiException {
        if (compareModels == null || compareModels.size() == 0) {
            throw new IllegalArgumentException("The model cannot be null or empty.");
        }
        Model[][] toCompare = new Model[compareModels.size()][2];
        int i = 0;
        for (CompareModel pair : compareModels) {
            toCompare[i++] = pair.getModels();
        }
        return this.compareApi.compareBulk(Compare.toJsonBulk(toCompare), this.retinaName);
    }

    public static class CompareModel {
        private Model[] models = new Model[2];

        public CompareModel() {
        }

        public CompareModel(Model model1, Model model2) {
            this.setModel1(model1);
            this.setModel2(model2);
        }

        public Model getModel1() {
            return this.models[0];
        }

        public void setModel1(Model model1) {
            this.models[0] = model1;
        }

        public Model getModel2() {
            return this.models[1];
        }

        public void setModel2(Model model2) {
            this.models[1] = model2;
        }

        public Model[] getModels() {
            return this.models;
        }
    }
}

