/*
 * Decompiled with CFR 0.152.
 */
package io.cortical.retina.core;

import com.fasterxml.jackson.core.JsonProcessingException;
import io.cortical.retina.core.AbstractEndpoint;
import io.cortical.retina.core.PosTag;
import io.cortical.retina.model.Fingerprint;
import io.cortical.retina.model.Language;
import io.cortical.retina.model.Text;
import io.cortical.retina.rest.ApiException;
import io.cortical.retina.rest.TextApi;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;

public class Texts
extends AbstractEndpoint {
    private final TextApi api;

    Texts(String apiKey, String basePath, String retinaName) {
        super(retinaName);
        if (StringUtils.isBlank((CharSequence)apiKey)) {
            throw new IllegalArgumentException("The apiKey cannot be null.");
        }
        if (StringUtils.isBlank((CharSequence)basePath)) {
            throw new IllegalArgumentException("The base path cannot be null.");
        }
        this.api = new TextApi(apiKey);
        this.api.setBasePath(basePath);
    }

    Texts(TextApi api, String retinaName) {
        super(retinaName);
        this.api = api;
    }

    public List<String> getKeywordsForText(String text) throws ApiException {
        if (text == null || StringUtils.isEmpty((CharSequence)text)) {
            throw new IllegalArgumentException("The text cannot be null.");
        }
        return this.api.getKeywordsForText(text, this.retinaName);
    }

    public Fingerprint getFingerprintForText(String text) throws ApiException {
        if (text == null || StringUtils.isEmpty((CharSequence)text)) {
            throw new IllegalArgumentException("The text cannot be null.");
        }
        return this.api.getRepresentationForText(text, this.retinaName).get(0);
    }

    public List<Fingerprint> getFingerprintsForTexts(List<String> texts, double sparsity) throws JsonProcessingException, ApiException {
        return this.api.getRepresentationsForBulkText(this.toJson(this.convertToTextModel(texts)), this.retinaName, sparsity);
    }

    public List<String> getTokensForText(String text, Set<PosTag> posTags) throws ApiException {
        if (text == null || StringUtils.isEmpty((CharSequence)text)) {
            throw new IllegalArgumentException("The text cannot be null.");
        }
        return this.api.getTokensForText(text, this.formatPosTags(posTags), this.retinaName);
    }

    public List<Text> getSlicesForText(String text, int startIndex, int maxResults, boolean includeFingerprint) throws ApiException {
        if (text == null || StringUtils.isEmpty((CharSequence)text)) {
            throw new IllegalArgumentException("The text cannot be null.");
        }
        return this.api.getSlicesForText(text, includeFingerprint, this.retinaName, startIndex, maxResults);
    }

    public Language getLanguageForText(String text) throws ApiException {
        if (text == null || StringUtils.isEmpty((CharSequence)text)) {
            throw new IllegalArgumentException("The text cannot be null.");
        }
        return this.api.getLanguage(text);
    }

    private String formatPosTags(Set<PosTag> posTags) {
        if (posTags == null || posTags.size() == 0) {
            return "";
        }
        ArrayList<PosTag> tags = new ArrayList<PosTag>(posTags);
        StringBuilder cluedPosTags = new StringBuilder();
        cluedPosTags.append(((PosTag)((Object)tags.get(0))).getLabel());
        for (int i = 1; i < tags.size(); ++i) {
            cluedPosTags.append(",");
            cluedPosTags.append(((PosTag)((Object)tags.get(i))).getLabel());
        }
        return cluedPosTags.toString();
    }
}

