/*
 * Decompiled with CFR 0.152.
 */
package io.cortical.retina.core;

import io.cortical.retina.core.AbstractEndpoint;
import io.cortical.retina.core.PosType;
import io.cortical.retina.model.Context;
import io.cortical.retina.model.Term;
import io.cortical.retina.rest.ApiException;
import io.cortical.retina.rest.TermsApi;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class Terms
extends AbstractEndpoint {
    private final TermsApi api;

    Terms(String apiKey, String basePath, String retinaName) {
        super(retinaName);
        if (StringUtils.isBlank((CharSequence)apiKey)) {
            throw new IllegalArgumentException("The apiKey cannot be null.");
        }
        if (StringUtils.isBlank((CharSequence)basePath)) {
            throw new IllegalArgumentException("The base path cannot be null.");
        }
        this.api = new TermsApi(apiKey);
        this.api.setBasePath(basePath);
    }

    Terms(TermsApi api, String retinaName) {
        super(retinaName);
        this.api = api;
    }

    public List<Term> getTerms(String term, int startIndex, int maxResults, boolean includeFingerprint) throws ApiException {
        return this.api.getTerm(term, includeFingerprint, this.retinaName, startIndex, maxResults);
    }

    public List<Context> getContextsForTerm(String term, int startIndex, int maxResults, boolean includeFingerprint) throws ApiException {
        this.validateTerm(term);
        return this.api.getContextsForTerm(term, includeFingerprint, this.retinaName, startIndex, maxResults);
    }

    public List<Term> getSimilarTermsForTerm(String term, int contextId, PosType posType, int startIndex, int maxResults, boolean includeFingerprint) throws ApiException {
        this.validateTerm(term);
        String posTypeName = null;
        if (posType != null && posType != PosType.ANY) {
            posTypeName = posType.name();
        }
        return this.api.getSimilarTerms(term, contextId, posTypeName, includeFingerprint, this.retinaName, startIndex, maxResults);
    }

    private void validateTerm(String term) {
        if (term == null || term.trim().length() == 0) {
            throw new IllegalArgumentException("The term cannot be null.");
        }
    }
}

