/*
 * Decompiled with CFR 0.152.
 */
package io.cortical.retina.core;

import com.fasterxml.jackson.core.JsonProcessingException;
import io.cortical.retina.core.AbstractEndpoint;
import io.cortical.retina.core.PosType;
import io.cortical.retina.model.Context;
import io.cortical.retina.model.Fingerprint;
import io.cortical.retina.model.Model;
import io.cortical.retina.model.Term;
import io.cortical.retina.rest.ApiException;
import io.cortical.retina.rest.ExpressionsApi;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class Expressions
extends AbstractEndpoint {
    private final ExpressionsApi expressionsApi;

    Expressions(String apiKey, String basePath, String retinaName) {
        super(retinaName);
        if (StringUtils.isBlank((CharSequence)apiKey)) {
            throw new IllegalArgumentException("The apiKey cannot be null.");
        }
        if (StringUtils.isBlank((CharSequence)basePath)) {
            throw new IllegalArgumentException("The base path cannot be null.");
        }
        this.expressionsApi = new ExpressionsApi(apiKey);
        this.expressionsApi.setBasePath(basePath);
    }

    Expressions(ExpressionsApi expressionsApi, String retinaName) {
        super(retinaName);
        this.expressionsApi = expressionsApi;
    }

    public Fingerprint getFingerprintForExpression(Model model, double sparsity) throws JsonProcessingException, ApiException {
        this.validateRequiredModels(model);
        return this.expressionsApi.resolveExpression(model.toJson(), this.retinaName, sparsity);
    }

    public <T extends Model> List<Fingerprint> getFingerprintsForExpressions(List<T> models, double sparsity) throws JsonProcessingException, ApiException {
        this.validateRequiredModels(models);
        return this.expressionsApi.resolveBulkExpression(this.toJson(models), this.retinaName, sparsity);
    }

    public List<Context> getContextsForExpression(Model model, int startIndex, int maxResults, double sparsity, boolean includeFingerprint) throws JsonProcessingException, ApiException {
        this.validateRequiredModels(model);
        return this.expressionsApi.getContextsForExpression(model.toJson(), includeFingerprint, this.retinaName, startIndex, maxResults, sparsity);
    }

    public <T extends Model> List<List<Context>> getContextsForExpressions(List<T> expressionModels, int startIndex, int maxResults, boolean includeFingerprint, double sparsity) throws JsonProcessingException, ApiException {
        this.validateRequiredModels(expressionModels);
        return this.expressionsApi.getContextsForBulkExpression(this.toJson(expressionModels), includeFingerprint, this.retinaName, startIndex, maxResults, sparsity);
    }

    public List<Term> getSimilarTermsForExpression(Model model, int startIndex, int maxResults, int contextId, PosType posType, boolean includeFingerprint, double sparsity) throws JsonProcessingException, ApiException {
        String posTypeName = null;
        if (posType != null && posType != PosType.ANY) {
            posTypeName = posType.name();
        }
        return this.expressionsApi.getSimilarTermsForExpressionContext(model.toJson(), contextId, posTypeName, includeFingerprint, this.retinaName, startIndex, maxResults, sparsity);
    }

    public <T extends Model> List<List<Term>> getSimilarTermsForExpressions(List<T> models, int startIndex, int maxResults, int contextId, PosType posType, boolean includeFingerprint, double sparsity) throws JsonProcessingException, ApiException {
        String posTypeName = null;
        if (posType != null && posType != PosType.ANY) {
            posTypeName = posType.name();
        }
        return this.expressionsApi.getSimilarTermsForBulkExpressionContext(this.toJson(models), contextId, posTypeName, includeFingerprint, this.retinaName, startIndex, maxResults, sparsity);
    }
}

