/*
 * Decompiled with CFR 0.152.
 */
package io.cortical.retina.core;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.cortical.retina.core.AbstractEndpoint;
import io.cortical.retina.model.CategoryFilter;
import io.cortical.retina.model.Sample;
import io.cortical.retina.rest.ApiException;
import io.cortical.retina.rest.ClassifyApi;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class Classify
extends AbstractEndpoint {
    private final ClassifyApi api;

    Classify(String apiKey, String basePath, String retinaName) {
        super(retinaName);
        if (StringUtils.isBlank((CharSequence)apiKey)) {
            throw new IllegalArgumentException("The apiKey cannot be null.");
        }
        if (StringUtils.isBlank((CharSequence)basePath)) {
            throw new IllegalArgumentException("The base path cannot be null.");
        }
        this.api = new ClassifyApi(apiKey);
        this.api.setBasePath(basePath);
    }

    Classify(ClassifyApi api, String retinaName) {
        super(retinaName);
        this.api = api;
    }

    public CategoryFilter createCategoryFilter(String filterName, List<String> positiveExamples, List<String> negativeExamples) throws ApiException {
        if (StringUtils.isEmpty((CharSequence)filterName) || positiveExamples == null || positiveExamples.isEmpty()) {
            throw new IllegalArgumentException("The text cannot be null.");
        }
        Sample sample = this.makeSample(positiveExamples, negativeExamples);
        String json = null;
        try {
            ObjectMapper mapper = new ObjectMapper();
            mapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
            json = mapper.writeValueAsString((Object)sample);
        }
        catch (JsonProcessingException e) {
            e.printStackTrace();
        }
        return this.api.createCategoryFilter(filterName, json, this.retinaName);
    }
}

