/*
 * Decompiled with CFR 0.152.
 */
package io.cortical.retina.core;

import com.fasterxml.jackson.core.JsonProcessingException;
import io.cortical.retina.model.Model;
import io.cortical.retina.model.Sample;
import io.cortical.retina.model.Text;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

abstract class AbstractEndpoint {
    protected final String retinaName;

    protected AbstractEndpoint(String retinaName) {
        if (StringUtils.isBlank((CharSequence)retinaName)) {
            throw new IllegalArgumentException("The retinaName cannot be null.");
        }
        this.retinaName = retinaName;
    }

    protected Sample makeSample(List<String> positiveExamples, List<String> negativeExamples) {
        List<Text> posEx = this.convertToTextModel(positiveExamples);
        List<Text> negEx = this.convertToTextModel(negativeExamples);
        Sample sample = new Sample();
        sample.addAllPositive(posEx);
        sample.addAllNegative(negEx);
        return sample;
    }

    protected void validateRequiredModels(Model ... models) {
        if (models == null || models.length == 0) {
            throw new IllegalArgumentException("The model cannot be null or empty.");
        }
        for (Model model : models) {
            if (model != null) continue;
            throw new IllegalArgumentException("The model cannot be null or empty.");
        }
    }

    protected <T extends Model> void validateRequiredModels(List<T> models) {
        if (models == null || models.size() == 0) {
            throw new IllegalArgumentException("The model cannot be null or empty.");
        }
        for (Model model : models) {
            if (model != null) continue;
            throw new IllegalArgumentException("The model cannot be null or empty.");
        }
    }

    protected List<Text> convertToTextModel(List<String> l) {
        ArrayList<Text> retVal = new ArrayList<Text>();
        if (l == null) {
            return retVal;
        }
        for (String s : l) {
            retVal.add(new Text(s));
        }
        return retVal;
    }

    protected String toJson(Model ... models) throws JsonProcessingException {
        return Model.toJson(models);
    }

    protected <T extends Model> String toJson(List<T> models) throws JsonProcessingException {
        return Model.toJson(models);
    }

    public static String toJsonBulk(Model[] ... modelsArrays) throws JsonProcessingException {
        return Model.toJsonBulk(modelsArrays);
    }
}

