/*
 * Decompiled with CFR 0.152.
 */
package io.cortical.retina.client;

import com.fasterxml.jackson.core.JsonProcessingException;
import io.cortical.retina.client.FullClient;
import io.cortical.retina.core.Endpoints;
import io.cortical.retina.core.PosType;
import io.cortical.retina.model.ExpressionFactory;
import io.cortical.retina.model.Fingerprint;
import io.cortical.retina.model.Metric;
import io.cortical.retina.model.Term;
import io.cortical.retina.model.Text;
import io.cortical.retina.rest.ApiException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class LiteClient {
    private static final String DEFAULT_SERVER = "http://api.cortical.io/rest";
    private static final String DEFAULT_RETINA = "en_associative";
    private Endpoints endpoints;
    private FullClient delegate;

    public LiteClient(String apiKey) {
        this(apiKey, DEFAULT_SERVER, DEFAULT_RETINA, new Endpoints(DEFAULT_RETINA, DEFAULT_SERVER, apiKey));
    }

    LiteClient(String apiKey, String apiServer, String retinaName, Endpoints ep) {
        this.endpoints = ep;
        this.delegate = new FullClient(apiKey, apiServer, retinaName, this.endpoints);
    }

    public List<String> getSimilarTerms(String string) throws JsonProcessingException, ApiException {
        List<Term> terms = this.delegate.getSimilarTermsForExpression(new Text(string), 0, 20, -1, PosType.ANY, false, 1.0);
        return this.termToString(terms);
    }

    public List<String> getSimilarTerms(int[] fingerprint) throws JsonProcessingException, ApiException {
        List<Term> terms = this.delegate.getSimilarTermsForExpression(new Fingerprint(fingerprint), 0, 20, -1, PosType.ANY, false, 1.0);
        return this.termToString(terms);
    }

    public List<String> getKeywords(String text) throws ApiException {
        return this.delegate.getKeywordsForText(text);
    }

    public int[] getFingerprint(String string) throws JsonProcessingException, ApiException {
        if (StringUtils.isEmpty((CharSequence)string)) {
            throw new ApiException(400, "Cannot get fingerprint from a null or empty string.");
        }
        Fingerprint fingerPrint = this.delegate.getFingerprintForExpression(ExpressionFactory.text(string));
        return fingerPrint == null ? null : fingerPrint.getPositions();
    }

    public double compare(String string1, String string2) throws JsonProcessingException, ApiException {
        if (StringUtils.isEmpty((CharSequence)string1) || StringUtils.isEmpty((CharSequence)string2)) {
            throw new ApiException(400, "Cannot get fingerprint from a null or empty string.");
        }
        Metric metric = this.delegate.compare(new Text(string1), new Text(string2));
        if (metric == null) {
            return 0.0;
        }
        return metric.getCosineSimilarity();
    }

    public double compare(int[] fingerprint1, int[] fingerprint2) throws ApiException, JsonProcessingException {
        if (fingerprint1 == null || fingerprint2 == null) {
            throw new ApiException(400, "Cannot get fingerprint from a null or empty fingerprint.");
        }
        Metric metric = this.delegate.compare(new Fingerprint(fingerprint1), new Fingerprint(fingerprint2));
        if (metric == null) {
            return 0.0;
        }
        return metric.getCosineSimilarity();
    }

    public double compare(String string, int[] fingerprint) throws ApiException, JsonProcessingException {
        if (StringUtils.isEmpty((CharSequence)string) || fingerprint == null) {
            throw new ApiException(400, "Cannot get fingerprint from a null or empty fingerprint.");
        }
        Fingerprint model = this.delegate.getFingerprintForExpression(ExpressionFactory.text(string));
        Metric metric = this.delegate.compare(model, new Fingerprint(fingerprint));
        if (metric == null) {
            return 0.0;
        }
        return metric.getCosineSimilarity();
    }

    public int[] createCategoryFilter(List<String> positiveExamples) throws JsonProcessingException, ApiException {
        return this.delegate.createCategoryFilter("anonymous", positiveExamples, null).getPositions();
    }

    private List<String> termToString(List<Term> terms) {
        ArrayList<String> retVal = new ArrayList<String>();
        if (terms != null) {
            for (Term t : terms) {
                retVal.add(t.getTerm());
            }
        }
        return retVal;
    }
}

