/*
 * Decompiled with CFR 0.152.
 */
package io.cortical.retina.client;

import com.fasterxml.jackson.core.JsonProcessingException;
import io.cortical.retina.core.Compare;
import io.cortical.retina.core.Endpoints;
import io.cortical.retina.core.ImageEncoding;
import io.cortical.retina.core.ImagePlotShape;
import io.cortical.retina.core.PosTag;
import io.cortical.retina.core.PosType;
import io.cortical.retina.model.CategoryFilter;
import io.cortical.retina.model.Context;
import io.cortical.retina.model.Fingerprint;
import io.cortical.retina.model.Image;
import io.cortical.retina.model.Language;
import io.cortical.retina.model.Metric;
import io.cortical.retina.model.Model;
import io.cortical.retina.model.Retina;
import io.cortical.retina.model.Term;
import io.cortical.retina.model.Text;
import io.cortical.retina.rest.ApiException;
import java.io.ByteArrayInputStream;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;

public class FullClient {
    private static final int MAX_RESULTS = 10;
    public static final int DEFAULT_SCALING_FACTOR = 1;
    public static final double DEFAULT_SPARSITY = 1.0;
    public static final Set<PosTag> DEFAULT_TAGS = new LinkedHashSet<PosTag>(Arrays.asList(PosTag.any()));
    private static final String DEFAULT_SERVER = "http://api.cortical.io/rest";
    private static final String DEFAULT_RETINA = "en_associative";
    private Endpoints endpoints;

    public FullClient(String apiKey) {
        this(apiKey, DEFAULT_SERVER, DEFAULT_RETINA);
    }

    public FullClient(String apiKey, String retinaName) {
        this(apiKey, DEFAULT_SERVER, retinaName, new Endpoints(retinaName, DEFAULT_SERVER, apiKey));
    }

    public FullClient(String apiKey, String apiServer, String retinaName) {
        this(apiKey, apiServer, retinaName, new Endpoints(retinaName, apiServer, apiKey));
    }

    FullClient(String apiKey, String apiServer, String retinaName, Endpoints ep) {
        this.endpoints = ep;
    }

    public List<Term> getTerms() throws ApiException {
        return this.getTerms(null, 0, 10, false);
    }

    public List<Term> getTerms(String term, int startIndex, int maxResults, boolean getFingerprint) throws ApiException {
        return this.endpoints.termsApi().getTerms(term, startIndex, maxResults, getFingerprint);
    }

    public List<Context> getContextsForTerm(String term) throws ApiException {
        return this.getContextsForTerm(term, 0, 10, false);
    }

    public List<Context> getContextsForTerm(String term, int startIndex, int maxResults, boolean getFingerprint) throws ApiException {
        return this.endpoints.termsApi().getContextsForTerm(term, startIndex, maxResults, getFingerprint);
    }

    public List<Term> getSimilarTermsForTerm(String term) throws ApiException {
        return this.getSimilarTermsForTerm(term, -1, PosType.ANY, 0, 10, false);
    }

    public List<Term> getSimilarTermsForTerm(String term, int contextId, PosType posType, int startIndex, int maxResults, boolean getFingerprint) throws ApiException {
        return this.endpoints.termsApi().getSimilarTermsForTerm(term, contextId, posType, 0, maxResults, getFingerprint);
    }

    public Fingerprint getFingerprintForText(String text) throws ApiException {
        return this.endpoints.textApi().getFingerprintForText(text);
    }

    public List<Fingerprint> getFingerprintsForTexts(List<String> texts) throws ApiException, JsonProcessingException {
        return this.getFingerprintsForTexts(texts, 1.0);
    }

    public List<Fingerprint> getFingerprintsForTexts(List<String> texts, double sparsity) throws ApiException, JsonProcessingException {
        return this.endpoints.textApi().getFingerprintsForTexts(texts, sparsity);
    }

    public List<String> getKeywordsForText(String text) throws ApiException {
        return this.endpoints.textApi().getKeywordsForText(text);
    }

    public List<String> getTokensForText(String text) throws ApiException {
        return this.getTokensForText(text, DEFAULT_TAGS);
    }

    public List<String> getTokensForText(String text, Set<PosTag> posTags) throws ApiException {
        return this.endpoints.textApi().getTokensForText(text, posTags);
    }

    public List<Text> getSlicesForText(String text) throws ApiException {
        return this.getSlicesForText(text, 0, 10, false);
    }

    public List<Text> getSlicesForText(String text, int startIndex, int maxResults, boolean getFingerprint) throws ApiException {
        return this.endpoints.textApi().getSlicesForText(text, startIndex, maxResults, getFingerprint);
    }

    public Language getLanguageForText(String text) throws ApiException {
        return this.endpoints.textApi().getLanguageForText(text);
    }

    public Fingerprint getFingerprintForExpression(Model model) throws JsonProcessingException, ApiException {
        return this.getFingerprintForExpression(model, 1.0);
    }

    public Fingerprint getFingerprintForExpression(Model model, double sparsity) throws JsonProcessingException, ApiException {
        return this.endpoints.expressionsApi().getFingerprintForExpression(model, sparsity);
    }

    public <T extends Model> List<Fingerprint> getFingerprintsForExpressions(List<T> models) throws JsonProcessingException, ApiException {
        return this.getFingerprintsForExpressions(models, 1.0);
    }

    public <T extends Model> List<Fingerprint> getFingerprintsForExpressions(List<T> models, double sparsity) throws JsonProcessingException, ApiException {
        return this.endpoints.expressionsApi().getFingerprintsForExpressions(models, sparsity);
    }

    public List<Context> getContextsForExpression(Model model) throws JsonProcessingException, ApiException {
        return this.getContextsForExpression(model, 0, 10, 1.0, false);
    }

    public List<Context> getContextsForExpression(Model model, int startIndex, int maxResults, double sparsity, boolean getFingerprint) throws JsonProcessingException, ApiException {
        return this.endpoints.expressionsApi().getContextsForExpression(model, startIndex, maxResults, sparsity, getFingerprint);
    }

    public <T extends Model> List<List<Context>> getContextsForExpressions(List<T> models) throws JsonProcessingException, ApiException {
        return this.getContextsForExpressions(models, 0, 10, false, 1.0);
    }

    public <T extends Model> List<List<Context>> getContextsForExpressions(List<T> models, int startIndex, int maxResults, boolean getFingerprint, double sparsity) throws JsonProcessingException, ApiException {
        return this.endpoints.expressionsApi().getContextsForExpressions(models, startIndex, maxResults, getFingerprint, sparsity);
    }

    public List<Term> getSimilarTermsForExpression(Model model) throws JsonProcessingException, ApiException {
        return this.endpoints.expressionsApi().getSimilarTermsForExpression(model, 0, 10, -1, PosType.ANY, false, 1.0);
    }

    public List<Term> getSimilarTermsForExpression(Model model, int startIndex, int maxResults, int contextId, PosType posType, boolean getFingerprint, double sparsity) throws JsonProcessingException, ApiException {
        return this.endpoints.expressionsApi().getSimilarTermsForExpression(model, startIndex, maxResults, contextId, posType, getFingerprint, sparsity);
    }

    public <T extends Model> List<List<Term>> getSimilarTermsForExpressions(List<T> models) throws JsonProcessingException, ApiException {
        return this.getSimilarTermsForExpressions(models, 0, 10, -1, PosType.ANY, false, 1.0);
    }

    public <T extends Model> List<List<Term>> getSimilarTermsForExpressions(List<T> models, int startIndex, int maxResults, int contextId, PosType posType, boolean getFingerprint, double sparsity) throws JsonProcessingException, ApiException {
        return this.endpoints.expressionsApi().getSimilarTermsForExpressions(models, startIndex, maxResults, contextId, posType, getFingerprint, sparsity);
    }

    public Metric compare(Model model1, Model model2) throws JsonProcessingException, ApiException {
        return this.endpoints.compareApi().compare(model1, model2);
    }

    public Metric[] compareBulk(List<Compare.CompareModel> compareModels) throws JsonProcessingException, ApiException {
        return this.endpoints.compareApi().compareBulk(compareModels);
    }

    public ByteArrayInputStream getImage(Model model) throws JsonProcessingException, ApiException {
        return this.endpoints.imageApi().getImage(model, 1, ImagePlotShape.CIRCLE, ImageEncoding.BASE64_PNG, 1.0);
    }

    public ByteArrayInputStream getImage(Model model, int scalar, ImagePlotShape shape, ImageEncoding imageEncoding, double sparsity) throws JsonProcessingException, ApiException {
        return this.endpoints.imageApi().getImage(model, scalar, shape, imageEncoding, sparsity);
    }

    public <T extends Model> List<Image> getImages(List<T> models) throws JsonProcessingException, ApiException {
        return this.endpoints.imageApi().getImages(models, false, 1, ImagePlotShape.CIRCLE, 1.0);
    }

    public <T extends Model> List<Image> getImages(List<T> models, boolean getFingerprint, int scalar, ImagePlotShape shape, double sparsity) throws JsonProcessingException, ApiException {
        return this.endpoints.imageApi().getImages(models, getFingerprint, scalar, shape, sparsity);
    }

    public <T extends Model> ByteArrayInputStream compareImage(List<T> models) throws JsonProcessingException, ApiException {
        return this.compareImage(models, 1, ImagePlotShape.CIRCLE, ImageEncoding.BASE64_PNG);
    }

    public <T extends Model> ByteArrayInputStream compareImage(List<T> models, int scalar, ImagePlotShape shape, ImageEncoding imageEncoding) throws JsonProcessingException, ApiException {
        return this.endpoints.imageApi().compareImage(models, scalar, shape, imageEncoding);
    }

    public CategoryFilter createCategoryFilter(String filterName, List<String> positiveExamples, List<String> negativeExamples) throws JsonProcessingException, ApiException {
        return this.endpoints.classifyApi().createCategoryFilter(filterName, positiveExamples, negativeExamples);
    }

    public List<Retina> getRetinas() throws ApiException {
        return this.endpoints.getAllRetinas();
    }

    public Retina getRetinas(String name) throws ApiException {
        return this.endpoints.retinaByName(name);
    }
}

