/*
 * Decompiled with CFR 0.152.
 */
package io.contextmap.spring.runtime.scanner.storage.jdbc.metadata;

import io.contextmap.spring.runtime.http.Parameters;
import io.contextmap.spring.runtime.model.storage.ForeignKey;
import io.contextmap.spring.runtime.model.storage.PrimaryKey;
import io.contextmap.spring.runtime.model.storage.StorageEntity;
import io.contextmap.spring.runtime.model.storage.StorageEntityColumn;
import io.contextmap.spring.runtime.model.storage.StorageEntityType;
import io.contextmap.spring.runtime.scanner.storage.jdbc.metadata.DatabaseScanData;
import java.sql.Connection;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DatabaseMetadataScanner {
    private static final int MAX_NR_OF_ENTITIES = 100;
    private static Logger logger = LoggerFactory.getLogger(DatabaseMetadataScanner.class);

    public static String getDatabaseCatalog(Connection con) {
        try {
            return con.getCatalog();
        }
        catch (Throwable t) {
            return "";
        }
    }

    public static String getDatabaseSchema(Connection con) {
        try {
            return con.getSchema();
        }
        catch (Throwable t) {
            return "";
        }
    }

    public List<StorageEntity> execute(Connection con, Parameters parameters) {
        ArrayList<StorageEntity> storageEntities = new ArrayList<StorageEntity>();
        try {
            DatabaseScanData scanData = new DatabaseScanData();
            scanData.setMetaData(con.getMetaData());
            if (parameters.getDefaultStorageSchema() != null && !parameters.getDefaultStorageSchema().isEmpty()) {
                scanData.setSchemaOrCatalogToScan(parameters.getDefaultStorageSchema());
            }
            scanData.setCurrentCatalog(DatabaseMetadataScanner.getDatabaseCatalog(con));
            scanData.setCurrentSchema(DatabaseMetadataScanner.getDatabaseSchema(con));
            this.initializeSchemaAndCatalogFilters(scanData);
            logger.debug("Filter on catalog: " + scanData.getCatalogFilter());
            logger.debug("Filter on schema: " + scanData.getSchemaFilter());
            this.extractStorageEntities(storageEntities, scanData, "TABLE", StorageEntityType.TABLE);
            this.extractStorageEntities(storageEntities, scanData, "VIEW", StorageEntityType.VIEW);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return storageEntities;
    }

    private void initializeSchemaAndCatalogFilters(DatabaseScanData scanData) {
        String schemaFilter = null;
        String catalogFilter = null;
        if (scanData.getSchemaOrCatalogToScan() != null) {
            Optional<String> matchingSchema = this.getSchemas(scanData).stream().filter(name -> name != null && name.equalsIgnoreCase(scanData.getSchemaOrCatalogToScan())).findFirst();
            if (matchingSchema.isPresent()) {
                schemaFilter = matchingSchema.get();
            } else {
                Optional<String> matchingCatalog = this.getCatalogs(scanData).stream().filter(name -> name != null && name.equalsIgnoreCase(scanData.getSchemaOrCatalogToScan())).findFirst();
                if (matchingCatalog.isPresent()) {
                    catalogFilter = matchingCatalog.get();
                }
            }
        } else {
            if (scanData.getCurrentCatalog() != null && !scanData.getCurrentCatalog().isEmpty()) {
                catalogFilter = scanData.getCurrentCatalog();
            }
            if (scanData.getCurrentSchema() != null && !scanData.getCurrentSchema().isEmpty()) {
                schemaFilter = scanData.getCurrentSchema();
            }
        }
        scanData.setCatalogFilter(catalogFilter);
        scanData.setSchemaFilter(schemaFilter);
    }

    private void extractStorageEntities(List<StorageEntity> storageEntities, DatabaseScanData scanData, String type, StorageEntityType storageEntityType) {
        if (storageEntities.size() > 100) {
            logger.warn("Not adding storage entities of type " + type + ", because maximum of " + 100 + " was reached.");
            return;
        }
        String[] types = new String[]{type};
        try (ResultSet rs = scanData.getMetaData().getTables(scanData.getCatalogFilter(), scanData.getSchemaFilter(), null, types);){
            while (rs.next()) {
                if (storageEntities.size() > 100) {
                    logger.warn("Not adding any more storage entities of type " + type + ", because maximum of " + 100 + " was reached.");
                    return;
                }
                String tableName = this.getSafeString(rs, "TABLE_NAME");
                String tableCategory = this.getSafeString(rs, "TABLE_CAT");
                String tableSchema = this.getSafeString(rs, "TABLE_SCHEM");
                String tableRemarks = this.getSafeString(rs, "REMARKS");
                StorageEntity storageEntity = new StorageEntity();
                storageEntity.setType(storageEntityType);
                storageEntity.setName(tableName);
                storageEntities.add(storageEntity);
                logger.debug("Found " + type.toLowerCase() + ": " + tableName + ", category " + tableCategory + ", schema " + tableSchema + ", remarks " + tableRemarks);
                storageEntity.setColumns(this.getColumns(scanData, tableName));
                storageEntity.setPrimaryKey(this.getPrimaryKey(scanData, tableName));
                storageEntity.setForeignKeys(this.getForeignKeys(scanData, tableName));
                this.getIndices(scanData, tableName);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private String getSafeString(ResultSet resultSet, String property) {
        try {
            return resultSet.getString(property);
        }
        catch (Throwable tt) {
            return "";
        }
    }

    private List<String> getSchemas(DatabaseScanData scanData) {
        ArrayList<String> schemaNames = new ArrayList<String>();
        try (ResultSet schemas = scanData.getMetaData().getSchemas();){
            while (schemas.next()) {
                String schema = this.getSafeString(schemas, "TABLE_SCHEM");
                schemaNames.add(schema);
                logger.info("Found schema " + schema);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return schemaNames;
    }

    private List<String> getCatalogs(DatabaseScanData scanData) {
        ArrayList<String> catalogNames = new ArrayList<String>();
        try (ResultSet catalogs = scanData.getMetaData().getCatalogs();){
            while (catalogs.next()) {
                String catalog = this.getSafeString(catalogs, "TABLE_CAT");
                catalogNames.add(catalog);
                logger.info("Found catalog " + catalog);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return catalogNames;
    }

    private List<StorageEntityColumn> getColumns(DatabaseScanData scanData, String tableName) {
        ArrayList<StorageEntityColumn> storageEntityColumns = new ArrayList<StorageEntityColumn>();
        try (ResultSet columns = scanData.getMetaData().getColumns(null, null, tableName, null);){
            while (columns.next()) {
                String columnName = this.getSafeString(columns, "COLUMN_NAME");
                String columnSize = this.getSafeString(columns, "COLUMN_SIZE");
                String datatype = this.getSafeString(columns, "DATA_TYPE");
                String isNullable = this.getSafeString(columns, "IS_NULLABLE");
                StorageEntityColumn storageEntityColumn = new StorageEntityColumn();
                storageEntityColumn.setName(columnName);
                storageEntityColumn.setDataType(this.convertDataTypeCodeToName(datatype, columnSize));
                storageEntityColumn.setNullable(this.convertNullableCodeToIsNullable(isNullable));
                storageEntityColumns.add(storageEntityColumn);
                logger.trace("  column " + storageEntityColumn.getName() + ": " + storageEntityColumn.getDataType() + " " + storageEntityColumn.isNullable());
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return storageEntityColumns;
    }

    private PrimaryKey getPrimaryKey(DatabaseScanData scanData, String tableName) {
        PrimaryKey primaryKey = null;
        try (ResultSet primaryKeys = scanData.getMetaData().getPrimaryKeys(null, null, tableName);){
            while (primaryKeys.next()) {
                String primaryKeyColumnName = this.getSafeString(primaryKeys, "COLUMN_NAME");
                String primaryKeyName = this.getSafeString(primaryKeys, "PK_NAME");
                if (primaryKey == null) {
                    primaryKey = new PrimaryKey();
                    primaryKey.setName(primaryKeyName);
                    primaryKey.setColumnNames(new ArrayList<String>());
                }
                primaryKey.getColumnNames().add(primaryKeyColumnName);
                logger.trace("  primary key " + primaryKeyColumnName + " named " + primaryKeyName);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return primaryKey;
    }

    private List<ForeignKey> getForeignKeys(DatabaseScanData scanData, String tableName) {
        HashMap<String, ForeignKey> fkNameToObjectMap = new HashMap<String, ForeignKey>();
        try (ResultSet foreignKeys = scanData.getMetaData().getImportedKeys(null, null, tableName);){
            while (foreignKeys.next()) {
                String pkTableName = this.getSafeString(foreignKeys, "PKTABLE_NAME");
                String fkTableName = this.getSafeString(foreignKeys, "FKTABLE_NAME");
                String pkColumnName = this.getSafeString(foreignKeys, "PKCOLUMN_NAME");
                String fkColumnName = this.getSafeString(foreignKeys, "FKCOLUMN_NAME");
                String foreignKeyName = this.getSafeString(foreignKeys, "FK_NAME");
                ForeignKey fk = (ForeignKey)fkNameToObjectMap.get(foreignKeyName);
                if (fk == null) {
                    fk = new ForeignKey();
                    fk.setName(foreignKeyName);
                    fk.setColumnNames(new ArrayList<String>());
                    fk.setTargetStorageEntityColumnNames(new ArrayList<String>());
                    fk.setTargetStorageEntityName(pkTableName);
                    fkNameToObjectMap.put(foreignKeyName, fk);
                }
                fk.getColumnNames().add(fkColumnName);
                fk.getTargetStorageEntityColumnNames().add(pkColumnName);
                logger.trace("  foreign key " + fkTableName + "." + fkColumnName + " -> " + pkTableName + "." + pkColumnName + " named " + foreignKeyName);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return new ArrayList<ForeignKey>(fkNameToObjectMap.values());
    }

    private void getIndices(DatabaseScanData scanData, String tableName) {
        try (ResultSet indices = scanData.getMetaData().getIndexInfo(null, null, tableName, false, true);){
            while (indices.next()) {
                String indexName = this.getSafeString(indices, "INDEX_NAME");
                String columnName = this.getSafeString(indices, "COLUMN_NAME");
                String nonUnique = this.getSafeString(indices, "NON_UNIQUE");
                logger.trace("  index on " + columnName + " named " + indexName + " nonUnique? " + nonUnique);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private boolean convertNullableCodeToIsNullable(String code) {
        return !"NO".equalsIgnoreCase(code);
    }

    private String convertDataTypeCodeToName(String code, String size) {
        int codeAsInt;
        try {
            codeAsInt = Integer.parseInt(code);
        }
        catch (Exception e) {
            return "unknown";
        }
        switch (codeAsInt) {
            case -7: {
                return "bit";
            }
            case -6: {
                return "tinyint";
            }
            case 5: {
                return "smallint";
            }
            case 4: {
                return "integer";
            }
            case -5: {
                return "bigint";
            }
            case 6: {
                return "float";
            }
            case 7: {
                return "real";
            }
            case 8: {
                return "double";
            }
            case 2: {
                return "numeric";
            }
            case 3: {
                return "decimal";
            }
            case 1: {
                if (size != null && !size.isEmpty()) {
                    return "char(" + size + ")";
                }
                return "char";
            }
            case 12: {
                if (size != null && !size.isEmpty()) {
                    return "varchar(" + size + ")";
                }
                return "varchar";
            }
            case -1: {
                if (size != null && !size.isEmpty()) {
                    return "longvarchar(" + size + ")";
                }
                return "longvarchar";
            }
            case 91: {
                return "date";
            }
            case 92: {
                return "time";
            }
            case 93: {
                return "timestamp";
            }
            case -2: {
                return "binary";
            }
            case -3: {
                return "varbinary";
            }
            case -4: {
                return "longvarbinary";
            }
            case 0: {
                return "null";
            }
            case 1111: {
                return "other";
            }
            case 2000: {
                return "javaobject";
            }
            case 2001: {
                return "distinct";
            }
            case 2002: {
                return "struct";
            }
            case 2003: {
                return "array";
            }
            case 2004: {
                return "blob";
            }
            case 2005: {
                return "clob";
            }
            case 2006: {
                return "ref";
            }
            case 70: {
                return "datalink";
            }
            case 16: {
                return "boolean";
            }
            case -8: {
                return "rowid";
            }
            case -15: {
                if (size != null && !size.isEmpty()) {
                    return "nchar(" + size + ")";
                }
                return "nchar";
            }
            case -9: {
                if (size != null && !size.isEmpty()) {
                    return "nvarchar(" + size + ")";
                }
                return "nvarchar";
            }
            case -16: {
                if (size != null && !size.isEmpty()) {
                    return "longnvarchar(" + size + ")";
                }
                return "longnvarchar";
            }
            case 2011: {
                return "nclob";
            }
            case 2009: {
                return "sqlxml";
            }
            case 2012: {
                return "ref-cursor";
            }
            case 2013: {
                return "time-with-timezone";
            }
            case 2014: {
                return "timestamp-with-timezone";
            }
        }
        return "unknown";
    }
}

