/*
 * Decompiled with CFR 0.152.
 */
package io.contextmap.spring.runtime.scanner.events.rabbitmq;

import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.core.Appender;
import io.contextmap.spring.runtime.model.Event;
import io.contextmap.spring.runtime.model.Scan;
import io.contextmap.spring.runtime.model.ScanApplicationContext;
import io.contextmap.spring.runtime.scanner.AbstractRuntimeScanner;
import io.contextmap.spring.runtime.scanner.events.EventFunctions;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.impl.StaticLoggerBinder;
import org.springframework.amqp.core.Binding;
import org.springframework.amqp.core.Declarable;
import org.springframework.amqp.core.Exchange;
import org.springframework.amqp.rabbit.core.RabbitAdmin;
import org.springframework.amqp.rabbit.core.RabbitTemplate;
import org.springframework.amqp.rabbit.logback.AmqpAppender;

public class RabbitMQScanner
extends AbstractRuntimeScanner {
    private static final Logger logger = LoggerFactory.getLogger(RabbitMQScanner.class);
    private final ScanApplicationContext context;

    public RabbitMQScanner(ScanApplicationContext context) {
        this.context = context;
    }

    @Override
    public void scan(Scan data) {
        Map<String, String> subscribedExchanges = this.getSubscribedExchanges();
        Set<Event> publishedEvents = this.getPublishedExchanges(subscribedExchanges);
        data.addPublishedEvents(publishedEvents);
        data.getExecution().setScannedPublishedEvents(true);
        Set<Event> subscribedEvents = subscribedExchanges.keySet().stream().map(Event::new).collect(Collectors.toSet());
        data.addSubscribedEvents(subscribedEvents);
        data.getExecution().setScannedSubscribedEvents(true);
    }

    private Map<String, String> getSubscribedExchanges() {
        Map<String, ?> bindingBeans = this.context.getBeansOfType("org.springframework.amqp.core.Binding");
        if (bindingBeans.isEmpty()) {
            return Collections.emptyMap();
        }
        HashMap<String, String> subscribedExchanges = new HashMap<String, String>();
        bindingBeans.values().stream().forEach(b -> {
            Binding binding = (Binding)b;
            String exchangeName = binding.getExchange();
            String virtualHostName = this.getVirtualHost((Declarable)binding);
            subscribedExchanges.put(this.formatName(virtualHostName, exchangeName), binding.getDestination());
        });
        return subscribedExchanges;
    }

    private Set<Event> getPublishedExchanges(Map<String, String> subscribedExchanges) {
        HashMap<String, Event> publishedEvents = new HashMap<String, Event>();
        this.getPublishedExchangesFromRabbitTemplates(subscribedExchanges).forEach(e -> publishedEvents.put(e.getName(), (Event)e));
        this.getPublishedExchangesAsEventsFromLogback().forEach(e -> publishedEvents.put(e.getName(), (Event)e));
        this.getPublishedExchangesFromExchanges(subscribedExchanges).forEach(e -> publishedEvents.put(e.getName(), (Event)e));
        Map<Class<?>, Set<EventFunctions.PayloadExchangeProperties>> eventClassToPublishers = EventFunctions.getPayloadProperties(this.context, this::resolveExchangeNameFromPublishedByName);
        EventFunctions.addPayloadsToEvents(eventClassToPublishers, publishedEvents);
        this.addPropertiesFromRabbitTemplates(publishedEvents);
        this.addPropertiesFromLogback(publishedEvents);
        this.addPropertiesFromExchanges(publishedEvents);
        return new HashSet<Event>(publishedEvents.values());
    }

    private String resolveExchangeNameFromPublishedByName(Class<?> eventClass, String publishedByName) {
        Optional<Object> optionalBean = this.context.getBeanByName(publishedByName);
        if (optionalBean.isPresent()) {
            Object bean = optionalBean.get();
            if (bean instanceof Exchange) {
                return this.getNameOfExchange((Exchange)bean);
            }
            if (bean instanceof RabbitTemplate) {
                return this.getNameOfExchange((RabbitTemplate)bean);
            }
            logger.warn("Unable to extract exchange name of ContextEvent {} since the bean is not a RabbitTemplate or Exchange, but it's of type {}", eventClass, bean.getClass());
            return "";
        }
        return this.context.resolveSpELStringValue(publishedByName);
    }

    private void addPropertiesFromExchanges(Map<String, Event> publishedEvents) {
        Map<String, ?> exchangeBeans = this.context.getBeansOfType("org.springframework.amqp.core.Exchange");
        exchangeBeans.values().forEach(ex -> {
            Exchange exchange = (Exchange)ex;
            String exchangeName = exchange.getName();
            String fullname = this.getNameOfExchange(exchange);
            if (publishedEvents.containsKey(fullname) && exchangeName != null && !exchangeName.isEmpty()) {
                Event event = (Event)publishedEvents.get(fullname);
                event.addPropertyIfValueNotBlank("Message Broker", "RabbitMQ");
                event.addPropertyIfValueNotBlank("Exchange Type", exchange.getType());
                event.addPropertyIfValueNotBlank("Exchange Name", exchangeName);
                event.addPropertyIfValueNotBlank("Virtual Host", this.formatVirtualHost(this.getVirtualHost((Declarable)exchange)));
                event.addPropertyIfValueNotBlank("Durable", Boolean.valueOf(exchange.isDurable()).toString());
                event.addPropertyIfValueNotBlank("Auto Delete", Boolean.valueOf(exchange.isAutoDelete()).toString());
                event.addPropertyIfValueNotBlank("Delayed", Boolean.valueOf(exchange.isDelayed()).toString());
                this.getRabbitAdmin((Declarable)exchange).ifPresent(rabbitAdmin -> {
                    RabbitTemplate tmpl = rabbitAdmin.getRabbitTemplate();
                    event.addPropertyIfValueNotBlank("Host", tmpl.getConnectionFactory().getHost());
                    event.addPropertyIfValueNotBlank("Username", tmpl.getConnectionFactory().getUsername());
                    event.addPropertyIfValueNotBlank("Port", String.valueOf(tmpl.getConnectionFactory().getPort()));
                });
            }
        });
    }

    private Set<Event> getPublishedExchangesFromExchanges(Map<String, String> subscribedExchanges) {
        HashSet<Event> events = new HashSet<Event>();
        Map<String, ?> exchangeBeans = this.context.getBeansOfType("org.springframework.amqp.core.Exchange");
        if (exchangeBeans.isEmpty()) {
            return Collections.emptySet();
        }
        exchangeBeans.values().forEach(ex -> {
            Exchange exchange = (Exchange)ex;
            String exchangeName = exchange.getName();
            String fullname = this.getNameOfExchange(exchange);
            if (!subscribedExchanges.containsKey(fullname) && exchangeName != null && !exchangeName.isEmpty()) {
                events.add(new Event(fullname));
            }
        });
        return events;
    }

    private String getNameOfExchange(Exchange exchange) {
        String exchangeName = exchange.getName();
        String virtualHostName = this.getVirtualHost((Declarable)exchange);
        return this.formatName(virtualHostName, exchangeName);
    }

    private String getNameOfExchange(RabbitTemplate rabbitTemplate) {
        String exchangeName = rabbitTemplate.getExchange();
        String virtualHostName = this.getVirtualHost(rabbitTemplate);
        return this.formatName(virtualHostName, exchangeName);
    }

    private void addPropertiesFromLogback(Map<String, Event> publishedEvents) {
        try {
            LoggerContext lc = (LoggerContext)StaticLoggerBinder.getSingleton().getLoggerFactory();
            for (ch.qos.logback.classic.Logger l : lc.getLoggerList()) {
                Iterator iter = l.iteratorForAppenders();
                while (iter.hasNext()) {
                    String exchangeName;
                    AmqpAppender amqpAppender;
                    String virtualHostName;
                    String name;
                    Appender appender = (Appender)iter.next();
                    if (!(appender instanceof AmqpAppender) || !publishedEvents.containsKey(name = this.formatName(virtualHostName = (amqpAppender = (AmqpAppender)appender).getVirtualHost(), exchangeName = amqpAppender.getExchangeName()))) continue;
                    Event event = publishedEvents.get(name);
                    event.addPropertyIfValueNotBlank("Message Broker", "RabbitMQ");
                    event.addPropertyIfValueNotBlank("Exchange Type", amqpAppender.getExchangeType());
                    event.addPropertyIfValueNotBlank("Host", amqpAppender.getHost());
                    event.addPropertyIfValueNotBlank("Username", amqpAppender.getUsername());
                    event.addPropertyIfValueNotBlank("Addresses", amqpAppender.getAddresses());
                    event.addPropertyIfValueNotBlank("Virtual Host", this.formatVirtualHost(amqpAppender.getVirtualHost()));
                    event.addPropertyIfValueNotBlank("Exchange Name", amqpAppender.getExchangeName());
                    event.addPropertyIfValueNotBlank("Port", amqpAppender.getPort() == null ? null : String.valueOf(amqpAppender.getPort()));
                    event.addPropertyIfValueNotBlank("Durable", Boolean.valueOf(amqpAppender.isDurable()).toString());
                    event.addPropertyIfValueNotBlank("Auto Delete", Boolean.valueOf(amqpAppender.isAutoDelete()).toString());
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private Set<Event> getPublishedExchangesAsEventsFromLogback() {
        HashSet<Event> events = new HashSet<Event>();
        try {
            LoggerContext lc = (LoggerContext)StaticLoggerBinder.getSingleton().getLoggerFactory();
            for (ch.qos.logback.classic.Logger l : lc.getLoggerList()) {
                Iterator iter = l.iteratorForAppenders();
                while (iter.hasNext()) {
                    Appender appender = (Appender)iter.next();
                    if (!(appender instanceof AmqpAppender)) continue;
                    AmqpAppender amqpAppender = (AmqpAppender)appender;
                    String virtualHostName = amqpAppender.getVirtualHost();
                    String exchangeName = amqpAppender.getExchangeName();
                    String name = this.formatName(virtualHostName, exchangeName);
                    events.add(new Event(name));
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return events;
    }

    private void addPropertiesFromRabbitTemplates(Map<String, Event> publishedEvents) {
        Map<String, ?> rabbitTemplateBeans = this.context.getBeansOfType("org.springframework.amqp.rabbit.core.RabbitTemplate");
        rabbitTemplateBeans.values().forEach(tmpl -> {
            RabbitTemplate rabbitTemplate = (RabbitTemplate)tmpl;
            String exchangeName = rabbitTemplate.getExchange();
            String fullname = this.getNameOfExchange(rabbitTemplate);
            if (publishedEvents.containsKey(fullname) && exchangeName != null && !exchangeName.isEmpty()) {
                Event event = (Event)publishedEvents.get(fullname);
                event.addPropertyIfValueNotBlank("Message Broker", "RabbitMQ");
                event.addPropertyIfValueNotBlank("Exchange Name", exchangeName);
                event.addPropertyIfValueNotBlank("Virtual Host", this.formatVirtualHost(this.getVirtualHost(rabbitTemplate)));
                event.addPropertyIfValueNotBlank("Host", rabbitTemplate.getConnectionFactory().getHost());
                event.addPropertyIfValueNotBlank("Username", rabbitTemplate.getConnectionFactory().getUsername());
                event.addPropertyIfValueNotBlank("Port", String.valueOf(rabbitTemplate.getConnectionFactory().getPort()));
            }
        });
    }

    private Set<Event> getPublishedExchangesFromRabbitTemplates(Map<String, String> subscribedExchanges) {
        Map<String, ?> rabbitTemplateBeans = this.context.getBeansOfType("org.springframework.amqp.rabbit.core.RabbitTemplate");
        if (rabbitTemplateBeans.isEmpty()) {
            return Collections.emptySet();
        }
        HashSet<Event> events = new HashSet<Event>();
        rabbitTemplateBeans.values().forEach(tmpl -> {
            RabbitTemplate rabbitTemplate = (RabbitTemplate)tmpl;
            String exchangeName = rabbitTemplate.getExchange();
            String fullname = this.getNameOfExchange(rabbitTemplate);
            if (!subscribedExchanges.containsKey(fullname) && exchangeName != null && !exchangeName.isEmpty()) {
                events.add(new Event(fullname));
            }
        });
        return events;
    }

    private Optional<RabbitAdmin> getRabbitAdmin(Declarable declarable) {
        Object admin;
        if (declarable.getDeclaringAdmins() != null && !declarable.getDeclaringAdmins().isEmpty() && (admin = declarable.getDeclaringAdmins().iterator().next()) instanceof RabbitAdmin) {
            return Optional.of((RabbitAdmin)admin);
        }
        return Optional.empty();
    }

    private String getVirtualHost(Declarable declarable) {
        return this.getRabbitAdmin(declarable).map(RabbitAdmin::getRabbitTemplate).map(this::getVirtualHost).orElse("");
    }

    private String getVirtualHost(RabbitTemplate rabbitTemplate) {
        return rabbitTemplate.getConnectionFactory().getVirtualHost();
    }

    private String formatName(String virtualHost, String exchangeOrQueue) {
        return this.formatVirtualHost(virtualHost) + ":" + exchangeOrQueue;
    }

    private String formatVirtualHost(String virtualHost) {
        if (virtualHost == null || virtualHost.trim().isEmpty()) {
            String defaultVH = this.context.getParameters().getDefaultRabbitVirtualHost();
            if (defaultVH != null && !defaultVH.trim().isEmpty()) {
                return defaultVH;
            }
            return "/";
        }
        return virtualHost;
    }
}

