/*
 * Decompiled with CFR 0.152.
 */
package io.contentchef.common.network;

import io.contentchef.common.data.ContentChefItemResponse;
import io.contentchef.common.data.ContentChefResponse;
import io.contentchef.common.data.ContentChefSearchResponse;
import io.contentchef.common.exception.BadRequestException;
import io.contentchef.common.exception.ContentChefErrorResponse;
import io.contentchef.common.exception.ContentNotFoundException;
import io.contentchef.common.exception.GenericErrorException;
import io.contentchef.common.exception.InvalidResponseException;
import io.contentchef.common.log.Logger;
import io.contentchef.common.network.ConnectionFactory;
import io.contentchef.common.network.ConnectionStreamReader;
import io.contentchef.common.network.ContentChefRequestData;
import io.contentchef.common.network.ContentChefResponseMapper;
import io.contentchef.common.util.StringExtensionsKt;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.UnknownHostException;
import java.util.logging.Level;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONObject;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0003\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0001\u001cB%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u0091\u0001\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010\u000e\u001a\u00020\u000f2+\b\u0002\u0010\u0010\u001a%\u0012\u0019\u0012\u0017\u0012\u0004\u0012\u00020\u00130\u0012\u00a2\u0006\f\b\u0014\u0012\b\b\u0015\u0012\u0004\b\b(\u0016\u0012\u0004\u0012\u00020\r\u0018\u00010\u00112+\b\u0002\u0010\u0017\u001a%\u0012\u0019\u0012\u0017\u0012\u0004\u0012\u00020\u00130\u0018\u00a2\u0006\f\b\u0014\u0012\b\b\u0015\u0012\u0004\b\b(\u0016\u0012\u0004\u0012\u00020\r\u0018\u00010\u00112!\u0010\u0019\u001a\u001d\u0012\u0013\u0012\u00110\u001a\u00a2\u0006\f\b\u0014\u0012\b\b\u0015\u0012\u0004\b\b(\u001b\u0012\u0004\u0012\u00020\r0\u0011R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lio/contentchef/common/network/RequestFactory;", "", "contentChefResponseMapper", "Lio/contentchef/common/network/ContentChefResponseMapper;", "connectionFactory", "Lio/contentchef/common/network/ConnectionFactory;", "connectionStreamReader", "Lio/contentchef/common/network/ConnectionStreamReader;", "logger", "Lio/contentchef/common/log/Logger;", "(Lio/contentchef/common/network/ContentChefResponseMapper;Lio/contentchef/common/network/ConnectionFactory;Lio/contentchef/common/network/ConnectionStreamReader;Lio/contentchef/common/log/Logger;)V", "generateRequest", "Lkotlin/Function0;", "", "contentChefRequestData", "Lio/contentchef/common/network/ContentChefRequestData;", "onItemSuccess", "Lkotlin/Function1;", "Lio/contentchef/common/data/ContentChefItemResponse;", "Lorg/json/JSONObject;", "Lkotlin/ParameterName;", "name", "contentChefResponse", "onSearchSuccess", "Lio/contentchef/common/data/ContentChefSearchResponse;", "onError", "", "throwable", "Configuration", "contentchef-jvm-common"})
public final class RequestFactory {
    private final ContentChefResponseMapper contentChefResponseMapper;
    private final ConnectionFactory connectionFactory;
    private final ConnectionStreamReader connectionStreamReader;
    private final Logger logger;

    @NotNull
    public final Function0<Unit> generateRequest(@NotNull ContentChefRequestData contentChefRequestData, @Nullable Function1<? super ContentChefItemResponse<JSONObject>, Unit> onItemSuccess, @Nullable Function1<? super ContentChefSearchResponse<JSONObject>, Unit> onSearchSuccess, @NotNull Function1<? super Throwable, Unit> onError) {
        Intrinsics.checkParameterIsNotNull((Object)contentChefRequestData, (String)"contentChefRequestData");
        Intrinsics.checkParameterIsNotNull(onError, (String)"onError");
        return (Function0)new Function0<Unit>(this, contentChefRequestData, onItemSuccess, onSearchSuccess, onError){
            final /* synthetic */ RequestFactory this$0;
            final /* synthetic */ ContentChefRequestData $contentChefRequestData;
            final /* synthetic */ Function1 $onItemSuccess;
            final /* synthetic */ Function1 $onSearchSuccess;
            final /* synthetic */ Function1 $onError;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public final void invoke() {
                block16: {
                    try {
                        HttpURLConnection $this$use$iv = RequestFactory.access$getConnectionFactory$p(this.this$0).getConnection(this.$contentChefRequestData);
                        boolean $i$f$use = false;
                        try {
                            int n;
                            HttpURLConnection connection = $this$use$iv;
                            boolean bl = false;
                            connection.setConnectTimeout(30000);
                            connection.setReadTimeout(30000);
                            connection.connect();
                            String responseContent = RequestFactory.access$getConnectionStreamReader$p(this.this$0).getContentAsString(connection);
                            Logger logger = RequestFactory.access$getLogger$p(this.this$0);
                            Level level = Level.INFO;
                            Intrinsics.checkExpressionValueIsNotNull((Object)level, (String)"Level.INFO");
                            Logger.DefaultImpls.log$default(logger, level, "ResponseContent " + responseContent, null, 4, null);
                            int n2 = n = connection.getResponseCode();
                            if (200 <= n2 && 299 >= n2) {
                                if (!StringExtensionsKt.isAValidJSONObject(responseContent)) {
                                    throw (Throwable)new InvalidResponseException(responseContent);
                                }
                                ContentChefResponse<JSONObject> contentChefResponse = RequestFactory.access$getContentChefResponseMapper$p(this.this$0).fromJsonObjectToContentChefResponse(new JSONObject(responseContent));
                                if (contentChefResponse instanceof ContentChefItemResponse) {
                                    Function1 function1 = this.$onItemSuccess;
                                    if (function1 == null) {
                                        Intrinsics.throwNpe();
                                    }
                                    function1.invoke(contentChefResponse);
                                } else if (contentChefResponse instanceof ContentChefSearchResponse) {
                                    Function1 function1 = this.$onSearchSuccess;
                                    if (function1 == null) {
                                        Intrinsics.throwNpe();
                                    }
                                    function1.invoke(contentChefResponse);
                                }
                                break block16;
                            }
                            if (n == 400) {
                                ContentChefErrorResponse contentChefErrorResponse = RequestFactory.access$getContentChefResponseMapper$p(this.this$0).fromJsonObjectToContentChefErrorResponse(new JSONObject(responseContent));
                                throw (Throwable)new BadRequestException(contentChefErrorResponse);
                            }
                            if (n == 404) {
                                throw (Throwable)new ContentNotFoundException();
                            }
                            ContentChefErrorResponse contentChefErrorResponse = RequestFactory.access$getContentChefResponseMapper$p(this.this$0).fromJsonObjectToContentChefErrorResponse(new JSONObject(responseContent));
                            throw (Throwable)new GenericErrorException(contentChefErrorResponse);
                        }
                        finally {
                            $this$use$iv.disconnect();
                        }
                    }
                    catch (UnknownHostException e) {
                        Logger logger = RequestFactory.access$getLogger$p(this.this$0);
                        Level level = Level.SEVERE;
                        Intrinsics.checkExpressionValueIsNotNull((Object)level, (String)"Level.SEVERE");
                        logger.log(level, "Unknown host", e);
                        this.$onError.invoke((Object)e);
                    }
                    catch (IOException e) {
                        Logger logger = RequestFactory.access$getLogger$p(this.this$0);
                        Level level = Level.SEVERE;
                        Intrinsics.checkExpressionValueIsNotNull((Object)level, (String)"Level.SEVERE");
                        logger.log(level, "Can't read response", e);
                        this.$onError.invoke((Object)e);
                    }
                    catch (Throwable e) {
                        Logger logger = RequestFactory.access$getLogger$p(this.this$0);
                        Level level = Level.SEVERE;
                        Intrinsics.checkExpressionValueIsNotNull((Object)level, (String)"Level.SEVERE");
                        logger.log(level, "Generic error", e);
                        this.$onError.invoke((Object)e);
                    }
                }
            }
            {
                this.this$0 = requestFactory;
                this.$contentChefRequestData = contentChefRequestData;
                this.$onItemSuccess = function1;
                this.$onSearchSuccess = function12;
                this.$onError = function13;
                super(0);
            }
        };
    }

    public static /* synthetic */ Function0 generateRequest$default(RequestFactory requestFactory, ContentChefRequestData contentChefRequestData, Function1 function1, Function1 function12, Function1 function13, int n, Object object) {
        if ((n & 2) != 0) {
            function1 = null;
        }
        if ((n & 4) != 0) {
            function12 = null;
        }
        return requestFactory.generateRequest(contentChefRequestData, (Function1<? super ContentChefItemResponse<JSONObject>, Unit>)function1, (Function1<? super ContentChefSearchResponse<JSONObject>, Unit>)function12, (Function1<? super Throwable, Unit>)function13);
    }

    public RequestFactory(@NotNull ContentChefResponseMapper contentChefResponseMapper, @NotNull ConnectionFactory connectionFactory, @NotNull ConnectionStreamReader connectionStreamReader, @NotNull Logger logger) {
        Intrinsics.checkParameterIsNotNull((Object)contentChefResponseMapper, (String)"contentChefResponseMapper");
        Intrinsics.checkParameterIsNotNull((Object)connectionFactory, (String)"connectionFactory");
        Intrinsics.checkParameterIsNotNull((Object)connectionStreamReader, (String)"connectionStreamReader");
        Intrinsics.checkParameterIsNotNull((Object)logger, (String)"logger");
        this.contentChefResponseMapper = contentChefResponseMapper;
        this.connectionFactory = connectionFactory;
        this.connectionStreamReader = connectionStreamReader;
        this.logger = logger;
    }

    public static final /* synthetic */ ConnectionFactory access$getConnectionFactory$p(RequestFactory $this) {
        return $this.connectionFactory;
    }

    public static final /* synthetic */ ConnectionStreamReader access$getConnectionStreamReader$p(RequestFactory $this) {
        return $this.connectionStreamReader;
    }

    public static final /* synthetic */ Logger access$getLogger$p(RequestFactory $this) {
        return $this.logger;
    }

    public static final /* synthetic */ ContentChefResponseMapper access$getContentChefResponseMapper$p(RequestFactory $this) {
        return $this.contentChefResponseMapper;
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u00c2\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lio/contentchef/common/network/RequestFactory$Configuration;", "", "()V", "CONNECTION_TIMEOUT_IN_MILLIS", "", "READ_TIMEOUT_IN_MILLIS", "contentchef-jvm-common"})
    private static final class Configuration {
        public static final int CONNECTION_TIMEOUT_IN_MILLIS = 30000;
        public static final int READ_TIMEOUT_IN_MILLIS = 30000;
        public static final Configuration INSTANCE;

        private Configuration() {
        }

        static {
            Configuration configuration;
            INSTANCE = configuration = new Configuration();
        }
    }
}

