/*
 * Decompiled with CFR 0.152.
 */
package io.contentchef.common.network;

import io.contentchef.common.data.ContentChefItemResponse;
import io.contentchef.common.data.ContentChefResponse;
import io.contentchef.common.data.ContentChefResponseMetadata;
import io.contentchef.common.data.ContentChefResponseRequestContext;
import io.contentchef.common.data.ContentChefSearchResponse;
import io.contentchef.common.exception.ContentChefErrorResponse;
import io.contentchef.common.exception.ErrorType;
import io.contentchef.common.exception.InvalidJsonResponseContentException;
import io.contentchef.common.util.ContentChefDateFormat;
import io.contentchef.common.util.JSONArrayExtensionsKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.json.JSONArray;
import org.json.JSONObject;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0002\u001d\u001eB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u0016\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\b2\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00060\n2\u0006\u0010\u0005\u001a\u00020\u0006J\u0016\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00060\f2\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0016\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0016\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u000f0\u00112\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u001a\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0014\u001a\u00020\u000fH\u0002J\u0012\u0010\u0015\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0016\u001a\u00020\u000fH\u0002J\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u0006H\u0002J\u001e\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0005\u001a\u00020\u00062\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u000f0\u0011H\u0002\u00a8\u0006\u001f"}, d2={"Lio/contentchef/common/network/ContentChefResponseMapper;", "", "()V", "fromJsonObjectToContentChefErrorResponse", "Lio/contentchef/common/exception/ContentChefErrorResponse;", "jsonObject", "Lorg/json/JSONObject;", "fromJsonObjectToContentChefItemResponse", "Lio/contentchef/common/data/ContentChefItemResponse;", "fromJsonObjectToContentChefResponse", "Lio/contentchef/common/data/ContentChefResponse;", "fromJsonObjectToContentChefSearchResponse", "Lio/contentchef/common/data/ContentChefSearchResponse;", "getValidationErrorConstraintsFromJsonObject", "", "", "getValidationErrorsFromJsonObject", "", "parseJsonDateFieldIfAvailable", "Ljava/util/Date;", "responseKey", "parseJsonStringToDate", "stringDate", "parseRequestContext", "Lio/contentchef/common/data/ContentChefResponseRequestContext;", "requestContextJsonObject", "validateJSONObjectFields", "", "mandatoryKeys", "ErrorKeys", "ResponseKeys", "contentchef-jvm-common"})
public final class ContentChefResponseMapper {
    public static final ContentChefResponseMapper INSTANCE;

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final ContentChefErrorResponse fromJsonObjectToContentChefErrorResponse(@NotNull JSONObject jsonObject) {
        List list;
        ErrorType errorType;
        Intrinsics.checkParameterIsNotNull((Object)jsonObject, (String)"jsonObject");
        if (jsonObject.has("type")) {
            String errorTypeString;
            String string = errorTypeString = jsonObject.getString("type");
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"errorTypeString");
            errorType = ErrorType.Companion.fromString(string);
        } else {
            errorType = ErrorType.GENERIC;
        }
        ErrorType errorType2 = errorType;
        String message = jsonObject.getString("message");
        if (jsonObject.has("validationsErrors")) {
            void $this$mapTo$iv$iv;
            JSONArray validationsErrors;
            JSONArray jSONArray = validationsErrors = jsonObject.getJSONArray("validationsErrors");
            Intrinsics.checkExpressionValueIsNotNull((Object)jSONArray, (String)"validationsErrors");
            Iterable $this$map$iv = JSONArrayExtensionsKt.toListOf(jSONArray);
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void validationsErrorJsonObject;
                JSONObject jSONObject = (JSONObject)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                List<String> list2 = INSTANCE.getValidationErrorsFromJsonObject((JSONObject)validationsErrorJsonObject);
                collection.add(list2);
            }
            list = (List)destination$iv$iv;
        } else {
            list = CollectionsKt.emptyList();
        }
        List failedConstraints = CollectionsKt.flatten((Iterable)list);
        String string = message;
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"message");
        return new ContentChefErrorResponse(errorType2, string, failedConstraints);
    }

    /*
     * WARNING - void declaration
     */
    private final List<String> getValidationErrorsFromJsonObject(JSONObject jsonObject) {
        Set set;
        if (jsonObject.has("children")) {
            JSONArray children = jsonObject.getJSONArray("children");
            if (children.length() > 0) {
                void $this$mapTo$iv$iv;
                JSONArray jSONArray = children;
                Intrinsics.checkExpressionValueIsNotNull((Object)jSONArray, (String)"children");
                Iterable $this$map$iv = JSONArrayExtensionsKt.toListOf(jSONArray);
                boolean $i$f$map = false;
                Iterable iterable = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    JSONObject jSONObject = (JSONObject)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    List<String> list = INSTANCE.getValidationErrorsFromJsonObject((JSONObject)it);
                    collection.add(list);
                }
                set = CollectionsKt.toSet((Iterable)CollectionsKt.flatten((Iterable)((List)destination$iv$iv)));
            } else {
                set = this.getValidationErrorConstraintsFromJsonObject(jsonObject);
            }
        } else {
            set = SetsKt.emptySet();
        }
        Set childrenValidationErrors = set;
        Set<String> validationErrors = this.getValidationErrorConstraintsFromJsonObject(jsonObject);
        return CollectionsKt.toList((Iterable)CollectionsKt.union((Iterable)childrenValidationErrors, (Iterable)validationErrors));
    }

    /*
     * WARNING - void declaration
     */
    private final Set<String> getValidationErrorConstraintsFromJsonObject(JSONObject jsonObject) {
        Collection<Object> collection;
        block5: {
            block3: {
                block4: {
                    void $this$mapNotNullTo$iv$iv;
                    if (!jsonObject.has("constraints")) break block3;
                    JSONObject constraintsJsonObject = jsonObject.getJSONObject("constraints");
                    collection = constraintsJsonObject.names();
                    if (collection == null || (collection = JSONArrayExtensionsKt.toListOf((JSONArray)collection)) == null) break block4;
                    Iterable $this$mapNotNull$iv = collection;
                    boolean $i$f$mapNotNull = false;
                    Iterable iterable = $this$mapNotNull$iv;
                    Collection destination$iv$iv = new ArrayList();
                    boolean $i$f$mapNotNullTo = false;
                    void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                    boolean $i$f$forEach = false;
                    Iterator iterator = $this$forEach$iv$iv$iv.iterator();
                    while (iterator.hasNext()) {
                        String string;
                        Object element$iv$iv$iv;
                        Object element$iv$iv = element$iv$iv$iv = iterator.next();
                        boolean bl = false;
                        String key = (String)element$iv$iv;
                        boolean bl2 = false;
                        if (constraintsJsonObject.getString(key) == null) continue;
                        boolean bl3 = false;
                        boolean bl4 = false;
                        String it$iv$iv = string;
                        boolean bl5 = false;
                        destination$iv$iv.add(it$iv$iv);
                    }
                    collection = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
                    if (collection != null) break block5;
                }
                collection = SetsKt.emptySet();
                break block5;
            }
            collection = SetsKt.emptySet();
        }
        return collection;
    }

    @NotNull
    public final ContentChefResponse<JSONObject> fromJsonObjectToContentChefResponse(@NotNull JSONObject jsonObject) {
        Intrinsics.checkParameterIsNotNull((Object)jsonObject, (String)"jsonObject");
        return jsonObject.has("items") ? (ContentChefResponse)this.fromJsonObjectToContentChefSearchResponse(jsonObject) : (ContentChefResponse)this.fromJsonObjectToContentChefItemResponse(jsonObject);
    }

    private final ContentChefItemResponse<JSONObject> fromJsonObjectToContentChefItemResponse(JSONObject jsonObject) {
        JSONObject requestContext;
        boolean contentChefItemResponseValid = this.validateJSONObjectFields(jsonObject, ResponseKeys.INSTANCE.getCONTENT_CHEF_ITEM_RESPONSE_MANDATORY_KEYS());
        if (!contentChefItemResponseValid) {
            throw (Throwable)new InvalidJsonResponseContentException();
        }
        JSONObject jSONObject = jsonObject.getJSONObject("metadata");
        Intrinsics.checkExpressionValueIsNotNull((Object)jSONObject, (String)"jsonObject.getJSONObject\u2026esponseKeys.KEY_METADATA)");
        boolean metadataResponseValid = this.validateJSONObjectFields(jSONObject, ResponseKeys.INSTANCE.getMETADATA_MANDATORY_KEYS());
        if (!metadataResponseValid) {
            throw (Throwable)new InvalidJsonResponseContentException();
        }
        JSONObject jSONObject2 = jsonObject.getJSONObject("requestContext");
        Intrinsics.checkExpressionValueIsNotNull((Object)jSONObject2, (String)"jsonObject.getJSONObject\u2026Keys.KEY_REQUEST_CONTEXT)");
        boolean requestContextValid = this.validateJSONObjectFields(jSONObject2, ResponseKeys.INSTANCE.getREQUEST_CONTEXT_KEYS());
        if (!requestContextValid) {
            throw (Throwable)new InvalidJsonResponseContentException();
        }
        String publicId = jsonObject.getString("publicId");
        String definition = jsonObject.getString("definition");
        String repository = jsonObject.getString("repository");
        JSONObject payload = jsonObject.getJSONObject("payload");
        String string = jsonObject.optString("onlineDate");
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"jsonObject.optString(ResponseKeys.KEY_ONLINE_DATE)");
        Date onlineDate = this.parseJsonStringToDate(string);
        String string2 = jsonObject.optString("offlineDate");
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"jsonObject.optString(Res\u2026nseKeys.KEY_OFFLINE_DATE)");
        Date offlineDate = this.parseJsonStringToDate(string2);
        JSONObject metadata = jsonObject.getJSONObject("metadata");
        long id = metadata.getLong("id");
        long authoringContentId = metadata.getLong("authoringContentId");
        long contentVersion = metadata.getLong("contentVersion");
        String string3 = metadata.getString("contentLastModifiedDate");
        Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"metadata.getString(Respo\u2026NTENT_LAST_MODIFIED_DATE)");
        Date date = this.parseJsonStringToDate(string3);
        if (date == null) {
            Intrinsics.throwNpe();
        }
        Date contentLastModifiedDate = date;
        JSONArray jSONArray = metadata.getJSONArray("tags");
        Intrinsics.checkExpressionValueIsNotNull((Object)jSONArray, (String)"metadata.getJSONArray(Re\u2026seKeys.KEY_METADATA_TAGS)");
        List<String> tags = JSONArrayExtensionsKt.toListOf(jSONArray);
        String string4 = metadata.getString("publishedOn");
        Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"metadata.getString(Respo\u2026EY_METADATA_PUBLISHED_ON)");
        Date date2 = this.parseJsonStringToDate(string4);
        if (date2 == null) {
            Intrinsics.throwNpe();
        }
        Date publishedOn = date2;
        ContentChefResponseMetadata contentChefResponseMetadata = new ContentChefResponseMetadata(id, authoringContentId, contentVersion, contentLastModifiedDate, tags, publishedOn);
        JSONObject jSONObject3 = requestContext = jsonObject.getJSONObject("requestContext");
        Intrinsics.checkExpressionValueIsNotNull((Object)jSONObject3, (String)"requestContext");
        ContentChefResponseRequestContext contentChefResponseRequestContext = this.parseRequestContext(jSONObject3);
        String string5 = publicId;
        Intrinsics.checkExpressionValueIsNotNull((Object)string5, (String)"publicId");
        String string6 = definition;
        Intrinsics.checkExpressionValueIsNotNull((Object)string6, (String)"definition");
        String string7 = repository;
        Intrinsics.checkExpressionValueIsNotNull((Object)string7, (String)"repository");
        JSONObject jSONObject4 = payload;
        Intrinsics.checkExpressionValueIsNotNull((Object)jSONObject4, (String)"payload");
        return new ContentChefItemResponse<JSONObject>(string5, string6, string7, jSONObject4, onlineDate, offlineDate, contentChefResponseMetadata, contentChefResponseRequestContext);
    }

    /*
     * WARNING - void declaration
     */
    private final ContentChefSearchResponse<JSONObject> fromJsonObjectToContentChefSearchResponse(JSONObject jsonObject) {
        JSONObject requestContext;
        void $this$mapTo$iv$iv;
        Object element$iv2;
        boolean contentChefSearchResponseValid = this.validateJSONObjectFields(jsonObject, ResponseKeys.INSTANCE.getCONTENT_CHEF_SEARCH_RESPONSE_MANDATORY_KEYS());
        if (!contentChefSearchResponseValid) {
            throw (Throwable)new InvalidJsonResponseContentException();
        }
        JSONArray jSONArray = jsonObject.getJSONArray("items");
        Intrinsics.checkExpressionValueIsNotNull((Object)jSONArray, (String)"jsonObject.getJSONArray(ResponseKeys.KEY_ITEMS)");
        List items = JSONArrayExtensionsKt.toListOf(jSONArray);
        Iterable $this$forEach$iv = items;
        boolean $i$f$forEach = false;
        for (Object element$iv2 : $this$forEach$iv) {
            JSONObject it = (JSONObject)element$iv2;
            boolean bl = false;
            boolean bl2 = INSTANCE.validateJSONObjectFields(it, ResponseKeys.INSTANCE.getCONTENT_CHEF_ITEM_RESPONSE_MANDATORY_KEYS());
            boolean bl3 = false;
            boolean bl4 = false;
            bl4 = false;
            boolean bl5 = false;
            if (bl2) continue;
            boolean bl6 = false;
            String string = "Failed requirement.";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        Iterable $this$map$iv = items;
        boolean $i$f$map = false;
        element$iv2 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            JSONObject jSONObject = (JSONObject)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            ContentChefItemResponse<JSONObject> contentChefItemResponse = INSTANCE.fromJsonObjectToContentChefItemResponse((JSONObject)it);
            collection.add(contentChefItemResponse);
        }
        List contentChefItemList = (List)destination$iv$iv;
        int skip = jsonObject.getInt("skip");
        int take = jsonObject.getInt("take");
        int total = jsonObject.getInt("total");
        JSONObject jSONObject = requestContext = jsonObject.getJSONObject("requestContext");
        Intrinsics.checkExpressionValueIsNotNull((Object)jSONObject, (String)"requestContext");
        ContentChefResponseRequestContext contentChefResponseRequestContext = this.parseRequestContext(jSONObject);
        return new ContentChefSearchResponse<JSONObject>(skip, take, total, contentChefItemList, contentChefResponseRequestContext);
    }

    private final ContentChefResponseRequestContext parseRequestContext(JSONObject requestContextJsonObject) {
        String publishingChannel = requestContextJsonObject.getString("publishingChannel");
        Date targetDate = this.parseJsonDateFieldIfAvailable(requestContextJsonObject, "targetDate");
        String cloudName = requestContextJsonObject.getString("cloudName");
        String string = requestContextJsonObject.getString("timestamp");
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"requestContextJsonObject\u2026EQUEST_CONTEXT_TIMESTAMP)");
        Date date = this.parseJsonStringToDate(string);
        if (date == null) {
            Intrinsics.throwNpe();
        }
        Date timestamp = date;
        String string2 = publishingChannel;
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"publishingChannel");
        String string3 = cloudName;
        Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"cloudName");
        return new ContentChefResponseRequestContext(string2, targetDate, string3, timestamp);
    }

    private final Date parseJsonDateFieldIfAvailable(JSONObject jsonObject, String responseKey) {
        Date date;
        if (jsonObject.has(responseKey)) {
            String string = jsonObject.getString(responseKey);
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"jsonObject.getString(responseKey)");
            date = this.parseJsonStringToDate(string);
        } else {
            date = null;
        }
        return date;
    }

    private final boolean validateJSONObjectFields(JSONObject jsonObject, List<String> mandatoryKeys) {
        Iterator iterator = jsonObject.keys();
        Intrinsics.checkExpressionValueIsNotNull((Object)iterator, (String)"jsonObject.keys()");
        return SequencesKt.toList((Sequence)SequencesKt.asSequence((Iterator)iterator)).containsAll((Collection)mandatoryKeys);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final Date parseJsonStringToDate(String stringDate) {
        String string = stringDate;
        switch (string.hashCode()) {
            case 0: {
                if (!string.equals("")) break;
                return null;
            }
            case 3392903: {
                if (!string.equals("null")) break;
                return null;
            }
        }
        Date date = ContentChefDateFormat.INSTANCE.parseDate(stringDate);
        return date;
    }

    private ContentChefResponseMapper() {
    }

    static {
        ContentChefResponseMapper contentChefResponseMapper;
        INSTANCE = contentChefResponseMapper = new ContentChefResponseMapper();
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u001f\b\u00c2\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0017\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\u0007R\u000e\u0010\n\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001e\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001f\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u0017\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\u0007R\u0017\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010\u0007\u00a8\u0006$"}, d2={"Lio/contentchef/common/network/ContentChefResponseMapper$ResponseKeys;", "", "()V", "CONTENT_CHEF_ITEM_RESPONSE_MANDATORY_KEYS", "", "", "getCONTENT_CHEF_ITEM_RESPONSE_MANDATORY_KEYS", "()Ljava/util/List;", "CONTENT_CHEF_SEARCH_RESPONSE_MANDATORY_KEYS", "getCONTENT_CHEF_SEARCH_RESPONSE_MANDATORY_KEYS", "KEY_DEFINITION", "KEY_ITEMS", "KEY_METADATA", "KEY_METADATA_AUTHORING_CONTENT_ID", "KEY_METADATA_CONTENT_LAST_MODIFIED_DATE", "KEY_METADATA_CONTENT_VERSION", "KEY_METADATA_ID", "KEY_METADATA_PUBLISHED_ON", "KEY_METADATA_TAGS", "KEY_OFFLINE_DATE", "KEY_ONLINE_DATE", "KEY_PAYLOAD", "KEY_PUBLIC_ID", "KEY_REPOSITORY", "KEY_REQUEST_CONTEXT", "KEY_REQUEST_CONTEXT_CLOUD_NAME", "KEY_REQUEST_CONTEXT_PUBLISHING_CHANNEL", "KEY_REQUEST_CONTEXT_TARGET_DATE", "KEY_REQUEST_CONTEXT_TIMESTAMP", "KEY_SKIP", "KEY_TAKE", "KEY_TOTAL", "METADATA_MANDATORY_KEYS", "getMETADATA_MANDATORY_KEYS", "REQUEST_CONTEXT_KEYS", "getREQUEST_CONTEXT_KEYS", "contentchef-jvm-common"})
    private static final class ResponseKeys {
        @NotNull
        public static final String KEY_PUBLIC_ID = "publicId";
        @NotNull
        public static final String KEY_DEFINITION = "definition";
        @NotNull
        public static final String KEY_REPOSITORY = "repository";
        @NotNull
        public static final String KEY_PAYLOAD = "payload";
        @NotNull
        public static final String KEY_ONLINE_DATE = "onlineDate";
        @NotNull
        public static final String KEY_OFFLINE_DATE = "offlineDate";
        @NotNull
        public static final String KEY_METADATA = "metadata";
        @NotNull
        public static final String KEY_REQUEST_CONTEXT = "requestContext";
        @NotNull
        public static final String KEY_METADATA_ID = "id";
        @NotNull
        public static final String KEY_METADATA_AUTHORING_CONTENT_ID = "authoringContentId";
        @NotNull
        public static final String KEY_METADATA_CONTENT_VERSION = "contentVersion";
        @NotNull
        public static final String KEY_METADATA_CONTENT_LAST_MODIFIED_DATE = "contentLastModifiedDate";
        @NotNull
        public static final String KEY_METADATA_TAGS = "tags";
        @NotNull
        public static final String KEY_METADATA_PUBLISHED_ON = "publishedOn";
        @NotNull
        public static final String KEY_REQUEST_CONTEXT_PUBLISHING_CHANNEL = "publishingChannel";
        @NotNull
        public static final String KEY_REQUEST_CONTEXT_TARGET_DATE = "targetDate";
        @NotNull
        public static final String KEY_REQUEST_CONTEXT_CLOUD_NAME = "cloudName";
        @NotNull
        public static final String KEY_REQUEST_CONTEXT_TIMESTAMP = "timestamp";
        @NotNull
        public static final String KEY_SKIP = "skip";
        @NotNull
        public static final String KEY_TAKE = "take";
        @NotNull
        public static final String KEY_TOTAL = "total";
        @NotNull
        public static final String KEY_ITEMS = "items";
        @NotNull
        private static final List<String> CONTENT_CHEF_ITEM_RESPONSE_MANDATORY_KEYS;
        @NotNull
        private static final List<String> METADATA_MANDATORY_KEYS;
        @NotNull
        private static final List<String> REQUEST_CONTEXT_KEYS;
        @NotNull
        private static final List<String> CONTENT_CHEF_SEARCH_RESPONSE_MANDATORY_KEYS;
        public static final ResponseKeys INSTANCE;

        @NotNull
        public final List<String> getCONTENT_CHEF_ITEM_RESPONSE_MANDATORY_KEYS() {
            return CONTENT_CHEF_ITEM_RESPONSE_MANDATORY_KEYS;
        }

        @NotNull
        public final List<String> getMETADATA_MANDATORY_KEYS() {
            return METADATA_MANDATORY_KEYS;
        }

        @NotNull
        public final List<String> getREQUEST_CONTEXT_KEYS() {
            return REQUEST_CONTEXT_KEYS;
        }

        @NotNull
        public final List<String> getCONTENT_CHEF_SEARCH_RESPONSE_MANDATORY_KEYS() {
            return CONTENT_CHEF_SEARCH_RESPONSE_MANDATORY_KEYS;
        }

        private ResponseKeys() {
        }

        static {
            ResponseKeys responseKeys;
            INSTANCE = responseKeys = new ResponseKeys();
            CONTENT_CHEF_ITEM_RESPONSE_MANDATORY_KEYS = CollectionsKt.listOf((Object[])new String[]{KEY_PUBLIC_ID, KEY_DEFINITION, KEY_REPOSITORY, KEY_PAYLOAD, KEY_ONLINE_DATE, KEY_OFFLINE_DATE, KEY_METADATA, KEY_REQUEST_CONTEXT});
            METADATA_MANDATORY_KEYS = CollectionsKt.listOf((Object[])new String[]{KEY_METADATA_ID, KEY_METADATA_AUTHORING_CONTENT_ID, KEY_METADATA_CONTENT_VERSION, KEY_METADATA_CONTENT_LAST_MODIFIED_DATE, KEY_METADATA_TAGS, KEY_METADATA_PUBLISHED_ON});
            REQUEST_CONTEXT_KEYS = CollectionsKt.listOf((Object[])new String[]{KEY_REQUEST_CONTEXT_PUBLISHING_CHANNEL, KEY_REQUEST_CONTEXT_CLOUD_NAME, KEY_REQUEST_CONTEXT_TIMESTAMP});
            CONTENT_CHEF_SEARCH_RESPONSE_MANDATORY_KEYS = CollectionsKt.listOf((Object[])new String[]{KEY_SKIP, KEY_TAKE, KEY_TOTAL, KEY_ITEMS, KEY_REQUEST_CONTEXT});
        }
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\b\u00c2\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lio/contentchef/common/network/ContentChefResponseMapper$ErrorKeys;", "", "()V", "KEY_MESSAGE", "", "KEY_TYPE", "KEY_VALIDATIONS_ERRORS", "KEY_VALIDATIONS_ERRORS_CHILDREN", "KEY_VALIDATIONS_ERRORS_CONSTRAINTS", "contentchef-jvm-common"})
    private static final class ErrorKeys {
        @NotNull
        public static final String KEY_TYPE = "type";
        @NotNull
        public static final String KEY_MESSAGE = "message";
        @NotNull
        public static final String KEY_VALIDATIONS_ERRORS = "validationsErrors";
        @NotNull
        public static final String KEY_VALIDATIONS_ERRORS_CHILDREN = "children";
        @NotNull
        public static final String KEY_VALIDATIONS_ERRORS_CONSTRAINTS = "constraints";
        public static final ErrorKeys INSTANCE;

        private ErrorKeys() {
        }

        static {
            ErrorKeys errorKeys;
            INSTANCE = errorKeys = new ErrorKeys();
        }
    }
}

