/*
 * Decompiled with CFR 0.152.
 */
package io.contentchef.common.network;

import io.contentchef.common.log.Logger;
import io.contentchef.common.network.ContentChefRequestData;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.util.Map;
import java.util.logging.Level;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lio/contentchef/common/network/ConnectionFactory;", "", "logger", "Lio/contentchef/common/log/Logger;", "(Lio/contentchef/common/log/Logger;)V", "getConnection", "Ljava/net/HttpURLConnection;", "contentChefRequestData", "Lio/contentchef/common/network/ContentChefRequestData;", "contentchef-jvm-common"})
public final class ConnectionFactory {
    private final Logger logger;

    @NotNull
    public final HttpURLConnection getConnection(@NotNull ContentChefRequestData contentChefRequestData) {
        Intrinsics.checkParameterIsNotNull((Object)contentChefRequestData, (String)"contentChefRequestData");
        try {
            String urlWithParams = contentChefRequestData.getUrl();
            Map<String, String> map = contentChefRequestData.getParams();
            boolean bl = false;
            if (!map.isEmpty()) {
                urlWithParams = urlWithParams + "?";
                boolean firstParam = true;
                Iterable $this$forEach$iv = contentChefRequestData.getParams().entrySet();
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    CharSequence charSequence;
                    Map.Entry entry = (Map.Entry)element$iv;
                    boolean bl2 = false;
                    if (!firstParam) {
                        urlWithParams = urlWithParams + "&";
                    } else {
                        firstParam = false;
                    }
                    urlWithParams = urlWithParams + (String)entry.getKey() + '=';
                    try {
                        StringBuilder stringBuilder = new StringBuilder().append(urlWithParams);
                        String string = URLEncoder.encode((String)entry.getValue(), "UTF-8");
                        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"URLEncoder.encode(\n     \u2026                        )");
                        charSequence = string;
                        String string2 = "\\+";
                        StringBuilder stringBuilder2 = stringBuilder;
                        boolean bl3 = false;
                        Object object = new Regex(string2);
                        string2 = object;
                        String string3 = "%20";
                        boolean bl4 = false;
                        object = string2.replace(charSequence, string3);
                        charSequence = stringBuilder2.append((String)object).toString();
                    }
                    catch (UnsupportedEncodingException e) {
                        charSequence = urlWithParams + (String)entry.getValue();
                    }
                    urlWithParams = charSequence;
                }
            }
            Level level = Level.INFO;
            Intrinsics.checkExpressionValueIsNotNull((Object)level, (String)"Level.INFO");
            Logger.DefaultImpls.log$default(this.logger, level, "Calling url: " + urlWithParams, null, 4, null);
            URL url = new URL(urlWithParams);
            URLConnection uRLConnection = url.openConnection();
            if (uRLConnection == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.net.HttpURLConnection");
            }
            HttpURLConnection connection = (HttpURLConnection)uRLConnection;
            connection.setRequestMethod(contentChefRequestData.getMethod().name());
            return connection;
        }
        catch (IOException e) {
            Level level = Level.INFO;
            Intrinsics.checkExpressionValueIsNotNull((Object)level, (String)"Level.INFO");
            this.logger.log(level, "Can't connect to " + contentChefRequestData.getUrl(), e);
            throw (Throwable)e;
        }
    }

    public ConnectionFactory(@NotNull Logger logger) {
        Intrinsics.checkParameterIsNotNull((Object)logger, (String)"logger");
        this.logger = logger;
    }
}

