/*
 * Decompiled with CFR 0.152.
 */
package io.contentchef.callback.common;

import io.contentchef.callback.common.CallbackContentChef;
import io.contentchef.callback.common.ConcurrentRequestExecutor;
import io.contentchef.callback.common.ContentChef;
import io.contentchef.common.configuration.ContentChefEnvironmentConfiguration;
import io.contentchef.common.log.AbstractLogger;
import io.contentchef.common.log.JavaUtilLoggingLogger;
import io.contentchef.common.log.Log4JLogger;
import io.contentchef.common.log.Logger;
import io.contentchef.common.log.NoLogger;
import io.contentchef.common.log.SLF4JLogger;
import io.contentchef.common.network.ConnectionFactory;
import io.contentchef.common.network.ConnectionStreamReader;
import io.contentchef.common.network.ContentChefResponseMapper;
import io.contentchef.common.network.RequestFactory;
import java.util.logging.Level;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bJ\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u0007\u001a\u00020\bH\u0002\u00a8\u0006\u000b"}, d2={"Lio/contentchef/callback/common/CallbackContentChefFactory;", "", "()V", "getContentChef", "Lio/contentchef/callback/common/ContentChef;", "contentChefEnvironmentConfiguration", "Lio/contentchef/common/configuration/ContentChefEnvironmentConfiguration;", "logEnabled", "", "getLogger", "Lio/contentchef/common/log/Logger;", "contentchef-jvm-callback-common"})
public final class CallbackContentChefFactory {
    public static final CallbackContentChefFactory INSTANCE;

    @NotNull
    public final ContentChef getContentChef(@NotNull ContentChefEnvironmentConfiguration contentChefEnvironmentConfiguration, boolean logEnabled) {
        Intrinsics.checkParameterIsNotNull((Object)contentChefEnvironmentConfiguration, (String)"contentChefEnvironmentConfiguration");
        Logger logger = this.getLogger(logEnabled);
        return new CallbackContentChef(contentChefEnvironmentConfiguration, new RequestFactory(ContentChefResponseMapper.INSTANCE, new ConnectionFactory(logger), ConnectionStreamReader.INSTANCE, logger), ConcurrentRequestExecutor.INSTANCE);
    }

    private final Logger getLogger(boolean logEnabled) {
        if (!logEnabled) {
            return (Logger)NoLogger.INSTANCE;
        }
        try {
            Class.forName("org.apache.logging.log4j.Logger");
            AbstractLogger.logInfo$default((AbstractLogger)Log4JLogger.INSTANCE, (String)"Log4J found, using its logger.", null, (int)2, null);
            return (Logger)Log4JLogger.INSTANCE;
        }
        catch (ClassNotFoundException e) {
            Level level = Level.INFO;
            Intrinsics.checkExpressionValueIsNotNull((Object)level, (String)"Level.INFO");
            Logger.DefaultImpls.log$default((Logger)JavaUtilLoggingLogger.INSTANCE, (Level)level, (String)"Log4J not found on classpath", null, (int)4, null);
            try {
                Class.forName("org.slf4j.Logger");
                AbstractLogger.logInfo$default((AbstractLogger)SLF4JLogger.INSTANCE, (String)"SLF4J found, using its logger.", null, (int)2, null);
                return (Logger)SLF4JLogger.INSTANCE;
            }
            catch (ClassNotFoundException e2) {
                Level level2 = Level.INFO;
                Intrinsics.checkExpressionValueIsNotNull((Object)level2, (String)"Level.INFO");
                Logger.DefaultImpls.log$default((Logger)JavaUtilLoggingLogger.INSTANCE, (Level)level2, (String)"SLF4J not found on classpath", null, (int)4, null);
                Level level3 = Level.INFO;
                Intrinsics.checkExpressionValueIsNotNull((Object)level3, (String)"Level.INFO");
                Logger.DefaultImpls.log$default((Logger)JavaUtilLoggingLogger.INSTANCE, (Level)level3, (String)"Using JavaUtilLoggingLogger", null, (int)4, null);
                return (Logger)JavaUtilLoggingLogger.INSTANCE;
            }
        }
    }

    private CallbackContentChefFactory() {
    }

    static {
        CallbackContentChefFactory callbackContentChefFactory;
        INSTANCE = callbackContentChefFactory = new CallbackContentChefFactory();
    }
}

