/*
 * Decompiled with CFR 0.152.
 */
package io.connecto.connectoapi;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;
import java.util.UUID;
import org.json.JSONException;
import org.json.JSONObject;

public class MessageBuilder {
    private final String mWriteKey;
    private static final String ENGAGE_DATE_FORMAT = "yyyy-MM-dd'T'HH:mm:ss";

    public MessageBuilder(String writeKey) {
        this.mWriteKey = writeKey;
    }

    public String guid() {
        return String.valueOf(UUID.randomUUID());
    }

    public String returnISODate() {
        TimeZone tz = TimeZone.getTimeZone("UTC");
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm'Z'");
        df.setTimeZone(tz);
        String nowAsISO = df.format(new Date());
        return nowAsISO;
    }

    public JSONObject getDefaultPayload(String eventType) {
        JSONObject payload = new JSONObject();
        String messageId = this.guid();
        long time = System.currentTimeMillis() / 1000L;
        try {
            payload.put("sentAt", (Object)this.returnISODate());
            JSONObject library = new JSONObject();
            library.put("name", (Object)"connecto-java");
            library.put("version", (Object)"1.0");
            JSONObject libraryDetails = new JSONObject();
            libraryDetails.putOnce("library", (Object)library);
            payload.putOnce("context", (Object)libraryDetails);
            payload.put("messageId", (Object)messageId);
            payload.put("type", (Object)eventType);
            payload.put("channel", (Object)"JDK");
            payload.put("writeKey", (Object)this.mWriteKey);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        return payload;
    }

    public JSONObject event(String distinctId, String eventName, String eventType, JSONObject properties) {
        try {
            JSONObject dataObj = this.getDefaultPayload(eventType);
            dataObj.put("event", (Object)eventName);
            if (distinctId != null) {
                dataObj.put("profileId", (Object)distinctId);
                dataObj.put("userId", (Object)distinctId);
            }
            JSONObject propertiesObj = null;
            propertiesObj = properties == null ? new JSONObject() : new JSONObject(properties.toString());
            dataObj.put("properties", (Object)propertiesObj);
            return dataObj;
        }
        catch (JSONException e) {
            throw new RuntimeException("Can't construct a Connecto message", e);
        }
    }

    public JSONObject set(String distinctId, String eventType, JSONObject traits) {
        return this.identify(distinctId, eventType, traits);
    }

    public JSONObject identify(String distinctId, String eventType, Object traits) {
        JSONObject dataObj = this.getDefaultPayload(eventType);
        if (null == traits) {
            throw new IllegalArgumentException("Cannot send null traits, use JSONObject.NULL instead");
        }
        try {
            dataObj.put("traits", traits);
        }
        catch (JSONException e) {
            throw new IllegalArgumentException("Cannot interpret traits as a JSON payload", e);
        }
        try {
            dataObj.put("writeKey", (Object)this.mWriteKey);
            if (distinctId != null) {
                dataObj.put("profileId", (Object)distinctId);
                dataObj.put("userId", (Object)distinctId);
            }
            return dataObj;
        }
        catch (JSONException e) {
            throw new RuntimeException("Can't construct a Connecto message", e);
        }
    }
}

