/*
 * Decompiled with CFR 0.152.
 */
package io.connecto.connectoapi;

import io.connecto.connectoapi.Base64Coder;
import io.connecto.connectoapi.ClientDelivery;
import io.connecto.connectoapi.ConnectoMessageException;
import io.connecto.connectoapi.ConnectoServerException;
import io.connecto.connectoapi.SegmentResponse;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConnectoAPI {
    private final String mEventsEndpoint;
    private final String mRulesEndPoint;
    private int mTimeoutMilliseconds;
    private static final int BUFFER_SIZE = 256;
    private static final int DEFAULT_READ_TIMEOUT_MILLIS = 120000;

    public ConnectoAPI() {
        this("http://api.connecto.io/import", "http://api.connecto.io/api/rules?userId=", 120000);
    }

    public ConnectoAPI(String endpoint, String rulesendpoint, int timeout) {
        this.mEventsEndpoint = endpoint;
        this.mRulesEndPoint = rulesendpoint;
        this.mTimeoutMilliseconds = timeout;
    }

    public void setTimeout(int timeoutInMs) {
        this.mTimeoutMilliseconds = timeoutInMs;
    }

    public void sendMessage(JSONObject message) throws ConnectoMessageException, IOException {
        ClientDelivery delivery = new ClientDelivery();
        delivery.addMessage(message);
        this.deliver(delivery);
    }

    public void deliver(ClientDelivery toSend) throws IOException {
        String postUrl = this.mEventsEndpoint;
        List<JSONObject> events = toSend.getEventsMessages();
        this.sendMessages(events, postUrl);
        List<JSONObject> user = toSend.getIdentifyMessages();
        this.sendMessages(user, postUrl);
    }

    private String getAuthorizationHeader(String readKey) {
        new Base64Coder();
        return "Basic " + new String(Base64Coder.encode(readKey.getBytes()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SegmentResponse getSegments(String readKey, String userId) throws IOException {
        URL endpoint = new URL(this.mRulesEndPoint + userId);
        HttpURLConnection conn = (HttpURLConnection)endpoint.openConnection();
        conn.setRequestMethod("GET");
        conn.setConnectTimeout(this.mTimeoutMilliseconds);
        conn.setReadTimeout(this.mTimeoutMilliseconds);
        String basicAuth = this.getAuthorizationHeader(readKey);
        conn.setRequestProperty("Authorization", basicAuth);
        InputStream responseStream = null;
        SegmentResponse segmentResponse = null;
        try {
            responseStream = conn.getInputStream();
            String response = this.slurp(responseStream);
            try {
                JSONArray segments = new JSONArray(response);
                segmentResponse = new SegmentResponse(segments);
            }
            catch (JSONException jSONException) {
                // empty catch block
            }
            SegmentResponse segmentResponse2 = segmentResponse;
            return segmentResponse2;
        }
        finally {
            if (responseStream != null) {
                try {
                    responseStream.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean sendData(String dataString, String endpointUrl) throws IOException {
        byte[] utf8data;
        URL endpoint = new URL(endpointUrl);
        HttpURLConnection conn = (HttpURLConnection)endpoint.openConnection();
        conn.setConnectTimeout(this.mTimeoutMilliseconds);
        conn.setReadTimeout(this.mTimeoutMilliseconds);
        conn.setDoOutput(true);
        conn.setRequestMethod("POST");
        conn.setRequestProperty("Content-Type", "application/json");
        try {
            utf8data = dataString.getBytes("utf-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("Connecto library requires utf-8 support", e);
        }
        OutputStream postStream = null;
        try {
            postStream = conn.getOutputStream();
            postStream.write(utf8data);
        }
        finally {
            if (postStream != null) {
                try {
                    postStream.close();
                }
                catch (IOException iOException) {}
            }
        }
        InputStream responseStream = null;
        String response = null;
        try {
            responseStream = conn.getInputStream();
            response = this.slurp(responseStream);
        }
        finally {
            if (responseStream != null) {
                try {
                    responseStream.close();
                }
                catch (IOException iOException) {}
            }
        }
        return response != null;
    }

    private void sendMessages(List<JSONObject> messages, String endpointUrl) throws IOException {
        for (int i = 0; i < messages.size(); i += 50) {
            String messagesString;
            boolean accepted;
            int endIndex = i + 50;
            List<JSONObject> batch = messages.subList(i, endIndex = Math.min(endIndex, messages.size()));
            if (batch.size() <= 0 || (accepted = this.sendData(messagesString = this.dataString(batch), endpointUrl))) continue;
            throw new ConnectoServerException("Server refused to accept messages, they may be malformed.", batch);
        }
    }

    private String dataString(List<JSONObject> messages) {
        JSONArray array = new JSONArray();
        for (JSONObject message : messages) {
            array.put((Object)message);
        }
        return array.toString();
    }

    private String slurp(InputStream in) throws IOException {
        StringBuilder out = new StringBuilder();
        InputStreamReader reader = new InputStreamReader(in, "utf8");
        char[] readBuffer = new char[256];
        int readCount = 0;
        do {
            if ((readCount = reader.read(readBuffer)) <= 0) continue;
            out.append(readBuffer, 0, readCount);
        } while (readCount != -1);
        return out.toString();
    }
}

