/*
 * Decompiled with CFR 0.152.
 */
package io.connecto.connectoapi;

import io.connecto.connectoapi.ConnectoMessageException;
import java.util.ArrayList;
import java.util.List;
import org.json.JSONException;
import org.json.JSONObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClientDelivery {
    private final List<JSONObject> mEventsMessages = new ArrayList<JSONObject>();
    private final List<JSONObject> mIdentifyMessages = new ArrayList<JSONObject>();

    public void addMessage(JSONObject message) {
        if (!this.isValidMessage(message)) {
            throw new ConnectoMessageException("Given JSONObject was not a valid Connecto message", message);
        }
        try {
            String messageType = message.getString("type");
            if (messageType.equals("track")) {
                this.mEventsMessages.add(message);
            } else if (messageType.equals("identify")) {
                this.mIdentifyMessages.add(message);
            }
        }
        catch (JSONException e) {
            throw new RuntimeException("Apparently valid Connecto message could not be interpreted.", e);
        }
    }

    public boolean isValidMessage(JSONObject message) {
        boolean ret = true;
        try {
            String messageType = message.getString("type");
            if (message == null) {
                ret = false;
            } else if (!messageType.equals("track") && !messageType.equals("identify")) {
                ret = false;
            }
        }
        catch (JSONException e) {
            ret = false;
        }
        return ret;
    }

    List<JSONObject> getEventsMessages() {
        return this.mEventsMessages;
    }

    List<JSONObject> getIdentifyMessages() {
        return this.mIdentifyMessages;
    }
}

