/*
 * Decompiled with CFR 0.152.
 */
package com.gambit.sdk.pubsub.responses.errors;

import com.gambit.sdk.pubsub.exceptions.PubSubException;
import com.gambit.sdk.pubsub.exceptions.PubSubResponseParseException;
import com.gambit.sdk.pubsub.responses.errors.PubSubIncorrectPermissionsResponse;
import com.gambit.sdk.pubsub.responses.errors.PubSubInvalidFormatResponse;
import com.gambit.sdk.pubsub.responses.errors.PubSubInvalidRequestResponse;
import com.gambit.sdk.pubsub.responses.errors.PubSubNoSubscriptionsResponse;
import com.gambit.sdk.pubsub.responses.errors.PubSubSubscriptionNotFoundResponse;
import java.util.Optional;
import org.json.JSONException;
import org.json.JSONObject;

public class PubSubErrorResponse {
    private int code;
    private String details;
    private String action;
    private String message;
    private String rawJson;
    private Long sequence;

    public static PubSubErrorResponse create(JSONObject response) throws PubSubException {
        try {
            if (!response.has("seq")) {
                return new PubSubInvalidRequestResponse(response);
            }
            switch (response.getInt("code")) {
                case 500: {
                    return new PubSubErrorResponse(response);
                }
                case 400: {
                    return new PubSubInvalidFormatResponse(response);
                }
                case 401: {
                    return new PubSubIncorrectPermissionsResponse(response);
                }
                case 404: {
                    switch (response.getString("action")) {
                        case "unsubscribe": {
                            return new PubSubSubscriptionNotFoundResponse(response);
                        }
                        case "pub": {
                            return new PubSubNoSubscriptionsResponse(response);
                        }
                    }
                    throw new PubSubResponseParseException("Unknown Error Response from Server", response);
                }
            }
            throw new PubSubResponseParseException("Unknown Error Response from Server", response);
        }
        catch (JSONException e) {
            throw new PubSubResponseParseException("Could Not Parse Error Response from Server", response);
        }
    }

    public PubSubErrorResponse(JSONObject response) throws JSONException {
        if (response.has("seq")) {
            this.sequence = response.getLong("seq");
        }
        if (response.has("details")) {
            this.details = response.getString("details");
        }
        if (response.has("action")) {
            this.action = response.getString("action");
        }
        if (response.has("message")) {
            this.message = response.getString("message");
        }
        this.code = response.getInt("code");
        this.rawJson = response.toString();
    }

    public int getCode() {
        return this.code;
    }

    public String getRawJson() {
        return this.rawJson;
    }

    public Optional<Long> getSequence() {
        return Optional.ofNullable(this.sequence);
    }

    public Optional<String> getDetails() {
        return Optional.ofNullable(this.details);
    }

    public Optional<String> getAction() {
        return Optional.ofNullable(this.action);
    }

    public Optional<String> getMessage() {
        return Optional.ofNullable(this.message);
    }
}

