/*
 * Decompiled with CFR 0.152.
 */
package com.gambit.sdk.pubsub;

import com.gambit.sdk.pubsub.PubSubDropConnectionOptions;
import com.gambit.sdk.pubsub.PubSubHandle;
import com.gambit.sdk.pubsub.PubSubMessageRecord;
import com.gambit.sdk.pubsub.PubSubOptions;
import com.gambit.sdk.pubsub.PubSubSocketConfigurator;
import com.gambit.sdk.pubsub.exceptions.PubSubErrorResponseException;
import com.gambit.sdk.pubsub.exceptions.PubSubException;
import com.gambit.sdk.pubsub.exceptions.PubSubSocketConnectionException;
import com.gambit.sdk.pubsub.exceptions.PubSubSocketImplementationException;
import com.gambit.sdk.pubsub.handlers.PubSubCloseHandler;
import com.gambit.sdk.pubsub.handlers.PubSubErrorHandler;
import com.gambit.sdk.pubsub.handlers.PubSubErrorResponseHandler;
import com.gambit.sdk.pubsub.handlers.PubSubMessageHandler;
import com.gambit.sdk.pubsub.handlers.PubSubNewSessionHandler;
import com.gambit.sdk.pubsub.handlers.PubSubRawRecordHandler;
import com.gambit.sdk.pubsub.handlers.PubSubReconnectHandler;
import com.gambit.sdk.pubsub.responses.errors.PubSubErrorResponse;
import com.gambit.sdk.pubsub.responses.successes.PubSubResponse;
import com.gambit.sdk.pubsub.utils.PubSubUtils;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.io.IOException;
import java.net.URI;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import javax.websocket.ClientEndpointConfig;
import javax.websocket.CloseReason;
import javax.websocket.ContainerProvider;
import javax.websocket.DeploymentException;
import javax.websocket.Endpoint;
import javax.websocket.EndpointConfig;
import javax.websocket.MessageHandler;
import javax.websocket.RemoteEndpoint;
import javax.websocket.SendHandler;
import javax.websocket.Session;
import javax.websocket.WebSocketContainer;
import org.json.JSONException;
import org.json.JSONObject;

public class PubSubSocket
extends Endpoint
implements MessageHandler.Whole<String> {
    private static final long DEFAULT_RECONNECT_DELAY = 5000L;
    private static final long MAX_RECONNECT_DELAY = 120000L;
    private static final ByteBuffer pingData = ByteBuffer.allocate(0);
    private List<String> projectKeys;
    private PubSubOptions options;
    private RemoteEndpoint.Async server;
    private Session websocketSession;
    private AtomicLong pingInterval;
    private AtomicBoolean doPings;
    private AtomicBoolean isConnected;
    private AtomicBoolean autoReconnect;
    private AtomicLong autoReconnectDelay;
    private UUID sessionUuid;
    private AtomicBoolean isNewSession;
    private Cache<Long, CompletableFuture<PubSubResponse>> outstanding;
    private Cache<Long, PubSubErrorResponseHandler> publishErrorHandlers;
    private Cache<Long, JSONObject> publishRequests;
    private Map<String, PubSubMessageHandler> msgHandlers;
    private PubSubNewSessionHandler newSessionHandler;
    private PubSubReconnectHandler reconnectHandler;
    private PubSubRawRecordHandler rawRecordHandler;
    private PubSubMessageHandler generalMsgHandler;
    private PubSubErrorResponseHandler errorResponseHandler;
    private PubSubErrorHandler errorHandler;
    private PubSubCloseHandler closeHandler;
    private IOException closeException;

    public static CompletableFuture<PubSubSocket> connectSocket(List<String> projectKeys, PubSubOptions options) {
        CompletableFuture<PubSubSocket> future = new CompletableFuture<PubSubSocket>();
        try {
            PubSubSocket socket = new PubSubSocket(projectKeys, options);
            ((CompletableFuture)socket.connect().thenAcceptAsync(voidReturn -> future.complete(socket))).exceptionally(error -> {
                future.completeExceptionally((Throwable)error);
                return null;
            });
        }
        catch (Exception e) {
            future.completeExceptionally(e);
        }
        return future;
    }

    protected PubSubSocket() {
        this.outstanding = CacheBuilder.newBuilder().expireAfterWrite(30L, TimeUnit.SECONDS).build();
        this.publishRequests = CacheBuilder.newBuilder().expireAfterWrite(30L, TimeUnit.SECONDS).build();
        this.publishErrorHandlers = CacheBuilder.newBuilder().expireAfterWrite(30L, TimeUnit.SECONDS).build();
        this.msgHandlers = Collections.synchronizedMap(new Hashtable());
        this.autoReconnectDelay = new AtomicLong(5000L);
        this.autoReconnect = new AtomicBoolean(false);
        this.isConnected = new AtomicBoolean(false);
        this.doPings = new AtomicBoolean(false);
        this.pingInterval = new AtomicLong(15L);
        this.options = PubSubOptions.DEFAULT_OPTIONS;
    }

    protected PubSubSocket(RemoteEndpoint.Async server) {
        this();
        this.server = server;
    }

    public PubSubSocket(List<String> projectKeys, PubSubOptions options) throws DeploymentException, IOException, PubSubException {
        this.projectKeys = projectKeys;
        this.options = options;
        this.sessionUuid = options.getSessionUuid();
        this.publishErrorHandlers = CacheBuilder.newBuilder().expireAfterWrite(30L, TimeUnit.SECONDS).build();
        this.publishRequests = CacheBuilder.newBuilder().expireAfterWrite(30L, TimeUnit.SECONDS).build();
        this.outstanding = CacheBuilder.newBuilder().expireAfterWrite(30L, TimeUnit.SECONDS).build();
        this.msgHandlers = Collections.synchronizedMap(new Hashtable());
        this.autoReconnectDelay = new AtomicLong(options.getConnectTimeout());
        this.autoReconnect = new AtomicBoolean(options.getAutoReconnect());
        this.isConnected = new AtomicBoolean(false);
        this.doPings = new AtomicBoolean(false);
        this.pingInterval = new AtomicLong(15L);
    }

    public void close() {
        this.autoReconnect.set(false);
        try {
            this.websocketSession.close(new CloseReason((CloseReason.CloseCode)CloseReason.CloseCodes.NORMAL_CLOSURE, "Initiated a Standard Close"));
        }
        catch (IOException e) {
            this.closeException = e;
        }
    }

    protected CompletableFuture<PubSubResponse> sendRequest(long sequence, JSONObject json) {
        CompletableFuture<PubSubResponse> result = new CompletableFuture<PubSubResponse>();
        this.outstanding.put((Object)sequence, result);
        this.server.sendText(json.toString(), sendResult -> {
            if (!sendResult.isOK()) {
                if (this.errorHandler != null) {
                    this.errorHandler.onError(sendResult.getException());
                }
                result.completeExceptionally(new Exception("Could not send JSON Object: " + json.toString()));
                this.outstanding.invalidate((Object)sequence);
            }
        });
        return result;
    }

    protected void sendPublish(long sequence, JSONObject json, PubSubErrorResponseHandler errorResponseHandler, SendHandler handler) {
        if (errorResponseHandler != null) {
            this.publishErrorHandlers.put((Object)sequence, (Object)errorResponseHandler);
        }
        this.server.sendText(json.toString(), sendResult -> {
            if (!sendResult.isOK()) {
                if (this.errorHandler != null) {
                    this.errorHandler.onError(sendResult.getException());
                }
                handler.onResult(sendResult);
            } else {
                handler.onResult(sendResult);
            }
        });
    }

    protected CompletableFuture<PubSubResponse> sendPublishWithAck(long sequence, JSONObject json, SendHandler handler) {
        CompletableFuture<PubSubResponse> result = new CompletableFuture<PubSubResponse>();
        this.outstanding.put((Object)sequence, result);
        this.server.sendText(json.toString(), sendResult -> {
            if (!sendResult.isOK()) {
                if (this.errorHandler != null) {
                    this.errorHandler.onError(sendResult.getException());
                }
                handler.onResult(sendResult);
            } else {
                handler.onResult(sendResult);
            }
        });
        return result;
    }

    protected void dropConnection(PubSubDropConnectionOptions dropOptions) {
        try {
            this.autoReconnectDelay.set(dropOptions.getAutoReconnectDelay());
            this.websocketSession.close(new CloseReason((CloseReason.CloseCode)CloseReason.CloseCodes.UNEXPECTED_CONDITION, "Dropped Connection"));
        }
        catch (IOException e) {
            this.closeException = e;
        }
    }

    private CompletableFuture<Void> connect() {
        CompletableFuture<Void> future = CompletableFuture.runAsync(() -> {
            PubSubSocketConfigurator configurator = new PubSubSocketConfigurator(this.projectKeys, this.sessionUuid);
            ClientEndpointConfig config = ClientEndpointConfig.Builder.create().configurator((ClientEndpointConfig.Configurator)configurator).build();
            WebSocketContainer container = ContainerProvider.getWebSocketContainer();
            if (container != null) {
                try {
                    this.websocketSession = container.connectToServer((Endpoint)this, config, URI.create(this.options.getUrl()));
                }
                catch (Exception e) {
                    throw new CompletionException(e);
                }
            } else {
                PubSubSocketImplementationException e = new PubSubSocketImplementationException("There was no socket container implementation found.");
                throw new CompletionException(e);
            }
            if (this.websocketSession == null) {
                PubSubSocketConnectionException e = new PubSubSocketConnectionException("Could not instantiate connection to server.");
                throw new CompletionException(e);
            }
        });
        return future;
    }

    private CompletableFuture<Void> reconnect() {
        return this.connect().whenComplete((pubsubsocket, error) -> {
            if (this.reconnectHandler != null) {
                this.reconnectHandler.onReconnect();
            }
        });
    }

    private void reconnectRetry(long msUntilNextRetry) {
        PubSubUtils.setTimeout(() -> ((CompletableFuture)this.reconnect().whenComplete((socket, error) -> {})).exceptionally(error -> {
            long minimumDelay = Math.max(5000L, msUntilNextRetry);
            long nextDelay = Math.min(minimumDelay * 2L, 120000L);
            this.reconnectRetry(nextDelay);
            return null;
        }), msUntilNextRetry);
    }

    private void pingRemoteRepeat(long msBetweenPings) {
        new Thread(() -> {
            while (this.doPings.get()) {
                try {
                    if (this.server != null && this.isConnected.get()) {
                        this.server.sendPing(pingData);
                    }
                    Thread.sleep(msBetweenPings);
                }
                catch (Exception e) {
                    if (this.errorHandler == null) continue;
                    this.errorHandler.onError(e);
                }
            }
        }).start();
    }

    public void onOpen(Session session, EndpointConfig config) {
        session.addMessageHandler((MessageHandler)this);
        this.server = session.getAsyncRemote();
        this.isConnected.set(true);
        this.doPings.set(true);
        this.pingRemoteRepeat(this.pingInterval.get());
        this.autoReconnectDelay.set(5000L);
        if (this.autoReconnect.get()) {
            ((CompletableFuture)new PubSubHandle(this, -1L).getSessionUuid().thenAccept(uuid -> {
                if (this.sessionUuid == null || !this.sessionUuid.toString().equals(uuid.toString())) {
                    this.sessionUuid = uuid;
                    if (this.newSessionHandler != null) {
                        this.newSessionHandler.onNewSession(this.sessionUuid);
                    }
                }
            })).exceptionally(error -> {
                this.isConnected.set(false);
                return null;
            });
        }
    }

    public void onClose(Session session, CloseReason closeReason) {
        this.server = null;
        this.doPings.set(false);
        this.isConnected.set(false);
        if (this.closeHandler != null) {
            this.closeHandler.onClose(this.closeException);
        }
        if (this.options.getAutoReconnect()) {
            this.reconnectRetry(this.autoReconnectDelay.get());
        }
    }

    public void onError(Session session, Throwable throwable) {
        throwable.printStackTrace();
        if (this.errorHandler != null) {
            this.errorHandler.onError(throwable);
        }
    }

    public void onMessage(String message) {
        block24: {
            if (this.rawRecordHandler != null) {
                this.rawRecordHandler.onRawRecord(message);
            }
            Long seq = null;
            try {
                block26: {
                    JSONObject json = new JSONObject(message);
                    if (json.getString("action").equals("msg")) {
                        try {
                            PubSubMessageRecord record = new PubSubMessageRecord(json);
                            PubSubMessageHandler handler = this.msgHandlers.get(record.getChannel());
                            handler.onMessage(record);
                            if (this.generalMsgHandler != null) {
                                this.generalMsgHandler.onMessage(record);
                            }
                            break block24;
                        }
                        catch (Exception e) {
                            if (this.errorHandler != null) {
                                this.errorHandler.onError(e);
                            }
                            break block24;
                        }
                    }
                    if (!json.has("seq")) {
                        try {
                            if (this.errorResponseHandler != null) {
                                this.errorResponseHandler.onErrorResponse(PubSubErrorResponse.create(json));
                            }
                            break block24;
                        }
                        catch (PubSubException e) {
                            if (this.errorHandler != null) {
                                this.errorHandler.onError(e);
                            }
                            break block24;
                        }
                    }
                    if (json.getInt("code") != 200) {
                        block25: {
                            seq = new Long(json.getLong("seq"));
                            CompletableFuture responseFuture = (CompletableFuture)this.outstanding.getIfPresent((Object)seq);
                            try {
                                PubSubErrorResponseHandler publishErrorResponseHandler = (PubSubErrorResponseHandler)this.publishErrorHandlers.getIfPresent((Object)seq);
                                PubSubErrorResponse errorResponse = PubSubErrorResponse.create(json);
                                if (responseFuture != null) {
                                    responseFuture.completeExceptionally(new PubSubErrorResponseException(errorResponse));
                                }
                                if (publishErrorResponseHandler != null) {
                                    publishErrorResponseHandler.onErrorResponse(errorResponse);
                                }
                                if (this.errorResponseHandler != null) {
                                    this.errorResponseHandler.onErrorResponse(errorResponse);
                                }
                            }
                            catch (PubSubException e) {
                                if (this.errorHandler == null) break block25;
                                this.errorHandler.onError(e);
                            }
                        }
                        this.outstanding.invalidate((Object)seq);
                        break block24;
                    }
                    seq = new Long(json.getLong("seq"));
                    CompletableFuture responseFuture = (CompletableFuture)this.outstanding.getIfPresent((Object)seq);
                    try {
                        if (responseFuture != null) {
                            responseFuture.complete(PubSubResponse.create(json));
                        }
                    }
                    catch (PubSubException ex) {
                        if (responseFuture != null) {
                            responseFuture.completeExceptionally(ex);
                        }
                        if (this.errorHandler == null) break block26;
                        this.errorHandler.onError(new PubSubException("Could not parse response: " + json.toString()));
                    }
                }
                this.outstanding.invalidate((Object)seq);
            }
            catch (JSONException e) {
                CompletableFuture responseFuture;
                if (seq != null && (responseFuture = (CompletableFuture)this.outstanding.getIfPresent(seq)) != null) {
                    responseFuture.completeExceptionally(e);
                }
                if (this.errorHandler == null) break block24;
                this.errorHandler.onError(e);
            }
        }
    }

    public void setNewSessionHandler(PubSubNewSessionHandler handler) {
        this.newSessionHandler = handler;
    }

    public void setReconnectHandler(PubSubReconnectHandler handler) {
        this.reconnectHandler = handler;
    }

    public void setRawRecordHandler(PubSubRawRecordHandler handler) {
        this.rawRecordHandler = handler;
    }

    public void setErrorHandler(PubSubErrorHandler handler) {
        this.errorHandler = handler;
    }

    public void setErrorResponseHandler(PubSubErrorResponseHandler handler) {
        this.errorResponseHandler = handler;
    }

    public void setCloseHandler(PubSubCloseHandler handler) {
        this.closeHandler = handler;
    }

    public void setMessageHandler(PubSubMessageHandler handler) {
        this.generalMsgHandler = handler;
    }

    public void addMessageHandler(String channel, PubSubMessageHandler handler) {
        this.msgHandlers.put(channel, handler);
    }

    public void removeMessageHandler(String channel) {
        this.msgHandlers.remove(channel);
    }
}

