/*
 * Decompiled with CFR 0.152.
 */
package com.gambit.sdk.pubsub;

import java.time.Duration;
import java.util.UUID;

public class PubSubOptions {
    private final String url;
    private final boolean autoReconnect;
    private final long connectTimeout;
    private final UUID sessionUuid;
    public static final PubSubOptions DEFAULT_OPTIONS = new PubSubOptions();

    private PubSubOptions() {
        this("wss://api.cogswell.io/pubsub", true, Duration.ofMinutes(5L), null);
    }

    public PubSubOptions(String url, Boolean autoReconnect, Duration connectTimeout, UUID sessionUuid) {
        this.url = url == null ? "wss://api.cogswell.io/pubsub" : url;
        this.autoReconnect = autoReconnect == null ? true : autoReconnect;
        this.sessionUuid = sessionUuid;
        this.connectTimeout = connectTimeout == null ? 30000L : connectTimeout.toMillis();
    }

    public String getUrl() {
        return this.url;
    }

    public boolean getAutoReconnect() {
        return this.autoReconnect;
    }

    public long getConnectTimeout() {
        return this.connectTimeout;
    }

    public UUID getSessionUuid() {
        return this.sessionUuid;
    }
}

