/*
 * Decompiled with CFR 0.152.
 */
package com.gambit.sdk.pubsub;

import java.time.Instant;
import java.util.UUID;
import org.json.JSONException;
import org.json.JSONObject;

public class PubSubMessageRecord {
    private final Instant timestamp;
    private final String channel;
    private final String message;
    private final UUID id;

    public PubSubMessageRecord(JSONObject jsonObj) throws JSONException {
        this.message = jsonObj.getString("msg");
        this.channel = jsonObj.getString("chan");
        this.id = UUID.fromString(jsonObj.getString("id"));
        this.timestamp = Instant.parse(jsonObj.getString("time"));
    }

    public String getChannel() {
        return this.channel;
    }

    public String getMessage() {
        return this.message;
    }

    public Instant getTimestamp() {
        return this.timestamp;
    }

    public UUID getId() {
        return this.id;
    }
}

