/*
 * Decompiled with CFR 0.152.
 */
package com.gambit.sdk.pubsub;

import com.gambit.sdk.pubsub.PubSubDropConnectionOptions;
import com.gambit.sdk.pubsub.PubSubSocket;
import com.gambit.sdk.pubsub.exceptions.PubSubResponseTypeException;
import com.gambit.sdk.pubsub.handlers.PubSubCloseHandler;
import com.gambit.sdk.pubsub.handlers.PubSubErrorHandler;
import com.gambit.sdk.pubsub.handlers.PubSubErrorResponseHandler;
import com.gambit.sdk.pubsub.handlers.PubSubMessageHandler;
import com.gambit.sdk.pubsub.handlers.PubSubNewSessionHandler;
import com.gambit.sdk.pubsub.handlers.PubSubRawRecordHandler;
import com.gambit.sdk.pubsub.handlers.PubSubReconnectHandler;
import com.gambit.sdk.pubsub.responses.successes.PubSubListSubscriptionsResponse;
import com.gambit.sdk.pubsub.responses.successes.PubSubPublishAckResponse;
import com.gambit.sdk.pubsub.responses.successes.PubSubResponse;
import com.gambit.sdk.pubsub.responses.successes.PubSubSessionUuidResponse;
import com.gambit.sdk.pubsub.responses.successes.PubSubSubscribeResponse;
import com.gambit.sdk.pubsub.responses.successes.PubSubUnsubscribeAllResponse;
import com.gambit.sdk.pubsub.responses.successes.PubSubUnsubscribeResponse;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicLong;
import org.json.JSONObject;

public class PubSubHandle {
    private AtomicLong sequence;
    private PubSubSocket socket;

    protected PubSubHandle(PubSubSocket socket) {
        this(socket, 0L);
    }

    protected PubSubHandle(PubSubSocket socket, long firstSequenceNumber) {
        this.sequence = new AtomicLong(firstSequenceNumber);
        this.socket = socket;
    }

    protected void dropConnection(PubSubDropConnectionOptions dropOptions) {
        this.socket.dropConnection(dropOptions);
    }

    public CompletableFuture<UUID> getSessionUuid() {
        CompletableFuture<UUID> outcome = new CompletableFuture<UUID>();
        long seq = this.sequence.getAndIncrement();
        JSONObject request = new JSONObject().put("seq", seq).put("action", (Object)"session-uuid");
        ((CompletableFuture)this.socket.sendRequest(seq, request).thenAcceptAsync(response -> {
            if (response instanceof PubSubSessionUuidResponse) {
                PubSubSessionUuidResponse uuidResponse = (PubSubSessionUuidResponse)response;
                outcome.complete(uuidResponse.getSessionUuid());
            } else {
                outcome.completeExceptionally(new PubSubResponseTypeException("Invalid Response to Session UUID", (PubSubResponse)response));
            }
        })).exceptionally(error -> {
            outcome.completeExceptionally((Throwable)error);
            return null;
        });
        return outcome;
    }

    public CompletableFuture<List<String>> subscribe(String channel, PubSubMessageHandler messageHandler) {
        CompletableFuture<List<String>> outcome = new CompletableFuture<List<String>>();
        long seq = this.sequence.getAndIncrement();
        JSONObject request = new JSONObject().put("seq", seq).put("action", (Object)"subscribe").put("channel", (Object)channel);
        this.socket.addMessageHandler(channel, messageHandler);
        ((CompletableFuture)this.socket.sendRequest(seq, request).thenAcceptAsync(response -> {
            if (response instanceof PubSubSubscribeResponse) {
                PubSubSubscribeResponse subResponse = (PubSubSubscribeResponse)response;
                outcome.complete(subResponse.getChannels());
            } else {
                outcome.completeExceptionally(new PubSubResponseTypeException("Invalid Response to Subscribing", (PubSubResponse)response));
            }
        })).exceptionally(error -> {
            this.socket.removeMessageHandler(channel);
            outcome.completeExceptionally((Throwable)error);
            return null;
        });
        return outcome;
    }

    public CompletableFuture<List<String>> unsubscribe(String channel) {
        CompletableFuture<List<String>> outcome = new CompletableFuture<List<String>>();
        long seq = this.sequence.getAndIncrement();
        JSONObject request = new JSONObject().put("seq", seq).put("action", (Object)"unsubscribe").put("channel", (Object)channel);
        ((CompletableFuture)this.socket.sendRequest(seq, request).thenAcceptAsync(response -> {
            if (response instanceof PubSubUnsubscribeResponse) {
                PubSubUnsubscribeResponse unsubResponse = (PubSubUnsubscribeResponse)response;
                outcome.complete(unsubResponse.getChannels());
            } else {
                outcome.completeExceptionally(new PubSubResponseTypeException("Invalid Response to Unsubscribing", (PubSubResponse)response));
            }
        })).exceptionally(error -> {
            outcome.completeExceptionally((Throwable)error);
            return null;
        });
        return outcome;
    }

    public CompletableFuture<List<String>> unsubscribeAll() {
        CompletableFuture<List<String>> outcome = new CompletableFuture<List<String>>();
        long seq = this.sequence.getAndIncrement();
        JSONObject request = new JSONObject().put("seq", seq).put("action", (Object)"unsubscribe-all");
        ((CompletableFuture)this.socket.sendRequest(seq, request).thenAcceptAsync(response -> {
            if (response instanceof PubSubUnsubscribeAllResponse) {
                PubSubUnsubscribeAllResponse unsubAllResponse = (PubSubUnsubscribeAllResponse)response;
                outcome.complete(unsubAllResponse.getChannels());
            } else {
                outcome.completeExceptionally(new PubSubResponseTypeException("Invalid Response to Unsubscribe All", (PubSubResponse)response));
            }
        })).exceptionally(error -> {
            outcome.completeExceptionally((Throwable)error);
            return null;
        });
        return outcome;
    }

    public CompletableFuture<List<String>> listSubscriptions() {
        CompletableFuture<List<String>> outcome = new CompletableFuture<List<String>>();
        long seq = this.sequence.getAndIncrement();
        JSONObject request = new JSONObject().put("seq", seq).put("action", (Object)"subscriptions");
        ((CompletableFuture)this.socket.sendRequest(seq, request).thenAcceptAsync(response -> {
            if (response instanceof PubSubListSubscriptionsResponse) {
                PubSubListSubscriptionsResponse listResponse = (PubSubListSubscriptionsResponse)response;
                outcome.complete(listResponse.getChannels());
            } else {
                outcome.completeExceptionally(new PubSubResponseTypeException("Invalid Response to List Subscriptions", (PubSubResponse)response));
            }
        })).exceptionally(error -> {
            outcome.completeExceptionally((Throwable)error);
            return null;
        });
        return outcome;
    }

    public CompletableFuture<Long> publish(String channel, String message, PubSubErrorResponseHandler handler) {
        CompletableFuture<Long> outcome = new CompletableFuture<Long>();
        long seq = this.sequence.getAndIncrement();
        JSONObject publish = new JSONObject().put("seq", seq).put("action", (Object)"pub").put("chan", (Object)channel).put("msg", (Object)message).put("ack", false);
        this.socket.sendPublish(seq, publish, handler, result -> {
            if (result.isOK()) {
                outcome.complete(seq);
            } else {
                outcome.completeExceptionally(result.getException());
            }
        });
        return outcome;
    }

    public CompletableFuture<Long> publish(String channel, String message) {
        CompletableFuture<Long> outcome = new CompletableFuture<Long>();
        long seq = this.sequence.getAndIncrement();
        JSONObject publish = new JSONObject().put("seq", seq).put("action", (Object)"pub").put("chan", (Object)channel).put("msg", (Object)message).put("ack", false);
        this.socket.sendPublish(seq, publish, null, result -> {
            if (result.isOK()) {
                outcome.complete(seq);
            } else {
                outcome.completeExceptionally(result.getException());
            }
        });
        return outcome;
    }

    public CompletableFuture<UUID> publishWithAck(String channel, String message) {
        CompletableFuture<UUID> outcome = new CompletableFuture<UUID>();
        long seq = this.sequence.getAndIncrement();
        JSONObject publish = new JSONObject().put("seq", seq).put("action", (Object)"pub").put("chan", (Object)channel).put("msg", (Object)message).put("ack", true);
        ((CompletableFuture)this.socket.sendPublishWithAck(seq, publish, sendResult -> {
            if (!sendResult.isOK()) {
                outcome.completeExceptionally(sendResult.getException());
            }
        }).thenAcceptAsync(response -> {
            if (response instanceof PubSubPublishAckResponse) {
                PubSubPublishAckResponse pubResponse = (PubSubPublishAckResponse)response;
                outcome.complete(pubResponse.getMessageId());
            } else {
                outcome.completeExceptionally(new PubSubResponseTypeException("Invalid Response to Publish With Ack", (PubSubResponse)response));
            }
        })).exceptionally(error -> {
            outcome.completeExceptionally((Throwable)error);
            return null;
        });
        return outcome;
    }

    public CompletableFuture<Void> close() {
        return CompletableFuture.runAsync(this.socket::close);
    }

    public void onMessage(PubSubMessageHandler messageHandler) {
        this.socket.setMessageHandler(messageHandler);
    }

    public void onReconnect(PubSubReconnectHandler reconnectHandler) {
        this.socket.setReconnectHandler(reconnectHandler);
    }

    public void onRawRecord(PubSubRawRecordHandler rawRecordHandler) {
        this.socket.setRawRecordHandler(rawRecordHandler);
    }

    public void onClose(PubSubCloseHandler closeHandler) {
        this.socket.setCloseHandler(closeHandler);
    }

    public void onError(PubSubErrorHandler errorHandler) {
        this.socket.setErrorHandler(errorHandler);
    }

    public void onErrorResponse(PubSubErrorResponseHandler errorResponseHandler) {
        this.socket.setErrorResponseHandler(errorResponseHandler);
    }

    public void onNewSession(PubSubNewSessionHandler newSessionHandler) {
        this.socket.setNewSessionHandler(newSessionHandler);
    }
}

