/*
 * Decompiled with CFR 0.152.
 */
package com.gambit.sdk.pubsub;

import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.List;
import java.util.UUID;
import java.util.Vector;
import java.util.stream.Collectors;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import javax.xml.bind.DatatypeConverter;
import org.json.JSONObject;

public class PubSubAuth {
    private String payload;
    private String payloadHmac;

    protected PubSubAuth(List<String> keys) throws NoSuchAlgorithmException, UnsupportedEncodingException, InvalidKeyException {
        this(keys, null);
    }

    protected PubSubAuth(List<String> keys, UUID session) throws NoSuchAlgorithmException, UnsupportedEncodingException, InvalidKeyException {
        if (0 >= keys.size() || keys.size() > 3) {
            throw new IllegalArgumentException("There must be at least one key in the keys list.");
        }
        this.generatePayload(keys, session);
    }

    protected String getPayload() {
        return this.payload;
    }

    protected String getHmac() {
        return this.payloadHmac;
    }

    private void generatePayload(List<String> keys, UUID session) throws NoSuchAlgorithmException, UnsupportedEncodingException, InvalidKeyException {
        List splitKeys = keys.stream().map(k -> k.split("-")).collect(Collectors.toList());
        String permissions = keys.stream().map(k -> k.substring(0, 1)).collect(Collectors.joining());
        String identity = ((String[])splitKeys.get(0))[1];
        String timestamp = ZonedDateTime.now(ZoneId.of("UTC")).format(DateTimeFormatter.ISO_INSTANT);
        JSONObject payload = new JSONObject().put("identity", (Object)identity).put("permissions", (Object)permissions).put("security_timestamp", (Object)timestamp);
        if (session != null) {
            payload.put("session_uuid", (Object)session.toString());
        }
        byte[] utf8Payload = payload.toString().getBytes("UTF-8");
        String base64Payload = DatatypeConverter.printBase64Binary((byte[])utf8Payload);
        this.generateHmac(keys, utf8Payload);
        this.payload = base64Payload;
    }

    private void generateHmac(List<String> keys, byte[] utf8Payload) throws NoSuchAlgorithmException, InvalidKeyException {
        Vector<ByteBuffer> permIdents = new Vector<ByteBuffer>();
        for (String key : keys) {
            String[] arr = key.split("-");
            String ident = arr[arr.length - 1];
            byte[] hex = DatatypeConverter.parseHexBinary((String)ident);
            Mac sha256Hmac = Mac.getInstance("HmacSHA256");
            sha256Hmac.init(new SecretKeySpec(hex, "HmacSHA256"));
            permIdents.add(ByteBuffer.wrap(sha256Hmac.doFinal(utf8Payload)));
        }
        byte[] accum = ((ByteBuffer)permIdents.get(0)).array();
        if (permIdents.size() > 1) {
            accum = this.byteXor(accum, ((ByteBuffer)permIdents.get(1)).array());
        }
        if (permIdents.size() > 2) {
            accum = this.byteXor(accum, ((ByteBuffer)permIdents.get(2)).array());
        }
        this.payloadHmac = DatatypeConverter.printHexBinary((byte[])accum);
        this.payloadHmac = this.payloadHmac.toLowerCase();
    }

    private byte[] byteXor(byte[] a, byte[] b) {
        byte[] result = new byte[a.length];
        for (int i = 0; i < result.length; ++i) {
            result[i] = (byte)(a[i] ^ b[i]);
        }
        return result;
    }
}

