/*
 * Decompiled with CFR 0.152.
 */
package com.gambit.sdk.message;

import org.json.JSONObject;

public class GambitMessage {
    protected String mMessageId;
    protected String mCiidHash;
    protected int mCampaignId = -1;
    protected String mCampaignName;
    protected String mNamespace;
    protected String mEventName;
    protected String mData;
    protected JSONObject mDataObject;
    protected boolean mIsValid;
    protected String mRawMessage;

    public GambitMessage(String message) {
        this.mRawMessage = message;
        this.mIsValid = true;
        JSONObject payload = null;
        try {
            payload = new JSONObject(this.mRawMessage);
        }
        catch (Exception e) {
            this.mIsValid = false;
            return;
        }
        if (payload.has("message_id")) {
            this.mMessageId = payload.getString("message_id");
        } else {
            this.mIsValid = false;
        }
        if (payload.has("ciid_hash")) {
            this.mCiidHash = payload.getString("ciid_hash");
        } else {
            this.mIsValid = false;
        }
        if (payload.has("campaign_id")) {
            this.mCampaignId = payload.getInt("campaign_id");
        } else {
            this.mIsValid = false;
        }
        if (payload.has("campaign_name")) {
            this.mCampaignName = payload.getString("campaign_name");
        } else {
            this.mIsValid = false;
        }
        if (payload.has("namespace")) {
            this.mNamespace = payload.getString("namespace");
        } else {
            this.mIsValid = false;
        }
        if (payload.has("event_name")) {
            this.mEventName = payload.getString("event_name");
        } else {
            this.mIsValid = false;
        }
        if (payload.has("data")) {
            this.mData = payload.getString("data");
            try {
                this.mDataObject = new JSONObject(this.mData);
            }
            catch (Exception e) {
                this.mIsValid = false;
            }
        }
    }

    public String getMessageId() {
        return this.mMessageId;
    }

    public String getCiidHash() {
        return this.mCiidHash;
    }

    public int getCampaignId() {
        return this.mCampaignId;
    }

    public String getCampaignName() {
        return this.mCampaignName;
    }

    public String getNamespace() {
        return this.mNamespace;
    }

    public String getEventName() {
        return this.mEventName;
    }

    public String getData() {
        return this.mData;
    }

    public JSONObject getDataObject() {
        return this.mDataObject;
    }

    public boolean isValid() {
        return this.mIsValid;
    }

    public String getRawMessage() {
        return this.mRawMessage;
    }
}

