/*
 * Decompiled with CFR 0.152.
 */
package com.gambit.sdk;

import com.gambit.sdk.exceptions.CogsException;
import java.io.IOException;
import java.net.URI;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import javax.websocket.ClientEndpoint;
import javax.websocket.ClientEndpointConfig;
import javax.websocket.CloseReason;
import javax.websocket.ContainerProvider;
import javax.websocket.Endpoint;
import javax.websocket.EndpointConfig;
import javax.websocket.MessageHandler;
import javax.websocket.PongMessage;
import javax.websocket.Session;
import javax.websocket.WebSocketContainer;

@ClientEndpoint
public class GambitWebsocketEndpoint
extends Endpoint {
    protected final ScheduledExecutorService mExecutorService = Executors.newSingleThreadScheduledExecutor();
    protected Runnable mPingRunnable = new Runnable(){

        @Override
        public void run() {
            GambitWebsocketEndpoint.this.sendPing();
        }
    };
    protected Runnable mRetryRunnable = new Runnable(){

        @Override
        public void run() {
            if (!GambitWebsocketEndpoint.this.isRunning()) {
                GambitWebsocketEndpoint.this.init();
            } else if (GambitWebsocketEndpoint.this.mRetryScheduler != null) {
                GambitWebsocketEndpoint.this.mRetryScheduler.cancel(true);
            }
        }
    };
    protected static final int MAX_FAST_RETRY = 5;
    protected static final int PING_RATE_MINUTES = 2;
    protected URI mEndpointUrl;
    protected String mPayload;
    protected String mSignature;
    protected MessageHandler.Whole<String> mMessageHandler;
    protected MessageHandler.Whole<PongMessage> mPingPongHandler;
    protected ScheduledFuture<?> mPingScheduler;
    protected ScheduledFuture<?> mRetryScheduler;
    protected Session mSession = null;
    protected WebSocketContainer mContainer;
    protected int mRetry = 0;
    protected boolean mIsRunning = false;

    public GambitWebsocketEndpoint(URI endpoint, String payload, String signature, MessageHandler.Whole<String> message_handler, MessageHandler.Whole<PongMessage> ping_handler) {
        this.mEndpointUrl = endpoint;
        this.mPayload = payload;
        this.mSignature = signature;
        this.mMessageHandler = message_handler;
        this.mPingPongHandler = ping_handler;
        this.init();
    }

    protected void init() {
        try {
            this.mContainer = ContainerProvider.getWebSocketContainer();
            ClientEndpointConfig.Configurator configurator = new ClientEndpointConfig.Configurator(){

                public void beforeRequest(Map<String, List<String>> headers) {
                    headers.put("Payload-HMAC", Collections.singletonList(GambitWebsocketEndpoint.this.mSignature));
                    headers.put("JSON-Base64", Collections.singletonList(GambitWebsocketEndpoint.this.mPayload));
                }
            };
            ClientEndpointConfig clientConfig = ClientEndpointConfig.Builder.create().configurator(configurator).build();
            this.mContainer.setDefaultMaxSessionIdleTimeout(300000L);
            this.mContainer.connectToServer((Endpoint)this, clientConfig, this.mEndpointUrl);
        }
        catch (Exception e) {
            throw new CogsException("Failed to initialize Cogs push WebSocket.", e);
        }
    }

    public Session getSession() {
        return this.mSession;
    }

    public void onOpen(Session session, EndpointConfig config) {
        this.mSession = session;
        this.mRetry = 0;
        this.mIsRunning = true;
        this.mSession.addMessageHandler(this.mMessageHandler);
        this.mSession.addMessageHandler(this.mPingPongHandler);
        this.mPingScheduler = this.mExecutorService.scheduleAtFixedRate(this.mPingRunnable, 2L, 2L, TimeUnit.MINUTES);
    }

    public void onClose(Session session, CloseReason closeReason) {
        super.onClose(session, closeReason);
        if (this.mPingScheduler != null && !this.mPingScheduler.isCancelled()) {
            this.mPingScheduler.cancel(true);
        }
        if (this.mRetryScheduler != null) {
            this.mRetryScheduler.cancel(true);
        }
        this.mIsRunning = false;
        if (!closeReason.getCloseCode().equals(CloseReason.CloseCodes.NORMAL_CLOSURE)) {
            ++this.mRetry;
            if (this.mRetry <= 5) {
                this.init();
            } else {
                this.mRetryScheduler = this.mExecutorService.scheduleAtFixedRate(this.mRetryRunnable, 1L, 1L, TimeUnit.MINUTES);
            }
        }
    }

    public void onError(Session session, Throwable thr) {
        super.onError(session, thr);
        this.mIsRunning = false;
        thr.printStackTrace();
    }

    public boolean isRunning() {
        return this.mIsRunning;
    }

    public void sendPing() {
        if (this.isRunning() && this.getSession() != null) {
            ByteBuffer buffer = ByteBuffer.allocate(1);
            buffer.put((byte)-1);
            try {
                this.getSession().getBasicRemote().sendPing(buffer);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }
}

