/*
 * Decompiled with CFR 0.152.
 */
package com.gambit.sdk;

import com.gambit.sdk.GambitPushService;
import com.gambit.sdk.GambitResponse;
import com.gambit.sdk.request.GambitRequestEvent;
import java.util.HashMap;
import java.util.Iterator;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;

public class GambitSDKService {
    protected static GambitSDKService mInstance;
    protected final ExecutorService mExecutor = Executors.newCachedThreadPool();
    protected HashMap<GambitPushService.Builder, GambitPushService> mPushInstances = new HashMap();
    protected GambitPushService.GambitMessageListener mMessageListener;
    protected String mEndpointHostname = "api.cogswell.io";

    protected GambitSDKService() throws RuntimeException {
    }

    public static GambitSDKService getInstance() throws RuntimeException {
        if (mInstance == null) {
            mInstance = new GambitSDKService();
        }
        return mInstance;
    }

    public void finish() {
        if (this.getExecutorService() != null && !this.getExecutorService().isShutdown()) {
            this.getExecutorService().shutdown();
        }
        if (this.mPushInstances != null && !this.mPushInstances.isEmpty()) {
            Iterator<GambitPushService.Builder> i = this.mPushInstances.keySet().iterator();
            while (i.hasNext()) {
                GambitPushService service = this.mPushInstances.get(i.next());
                service.shutdown();
            }
        }
    }

    protected ExecutorService getExecutorService() {
        return this.mExecutor;
    }

    public void setEndpointUrl(String hostname) {
        this.mEndpointHostname = hostname;
    }

    public String getEndpointHostname() {
        return this.mEndpointHostname;
    }

    public Future<GambitResponse> sendGambitEvent(GambitRequestEvent.Builder builder) throws Exception {
        return this.mExecutor.submit(builder.build());
    }

    public void setGambitMessageListener(GambitPushService.GambitMessageListener listener) {
        this.mMessageListener = listener;
        this.applyGambitMessageListener();
    }

    protected void applyGambitMessageListener() {
        if (this.mPushInstances != null && !this.mPushInstances.isEmpty()) {
            Iterator<GambitPushService.Builder> i = this.mPushInstances.keySet().iterator();
            while (i.hasNext()) {
                GambitPushService service = this.mPushInstances.get(i.next());
                service.setListener(this.mMessageListener);
            }
        }
    }

    public GambitPushService startPushService(GambitPushService.Builder builder) throws Exception {
        GambitPushService service = builder.build();
        service.setListener(this.mMessageListener);
        this.mPushInstances.put(builder, service);
        return service;
    }
}

