/*
 * Decompiled with CFR 0.152.
 */
package com.gambit.sdk;

import org.json.JSONException;
import org.json.JSONObject;

public class GambitResponse {
    protected String mRawBody;
    protected int mRawCode;
    protected boolean mIsSuccess;
    protected String mErrorCode;
    protected String mErrorDetails;
    protected JSONObject mJson;

    public GambitResponse(String response, int code) {
        this.mRawBody = response;
        this.mRawCode = code;
        try {
            this.mJson = new JSONObject(response);
            if (this.mJson.has("error_message")) {
                this.mIsSuccess = false;
                this.mErrorCode = this.mJson.getString("error_message");
                if (this.mJson.has("details")) {
                    this.mErrorDetails = this.mJson.getString("details");
                }
            } else {
                this.mIsSuccess = true;
            }
        }
        catch (JSONException e) {
            this.mIsSuccess = false;
            this.mErrorCode = "UNKNOWN";
            this.mErrorDetails = e.getMessage() + ": " + response;
        }
    }

    public String getRawBody() {
        return this.mRawBody;
    }

    public int getRawCode() {
        return this.mRawCode;
    }

    public boolean isSuccess() {
        return this.mIsSuccess;
    }

    public JSONObject getObject() {
        return this.mJson;
    }
}

