/*
 * Decompiled with CFR 0.152.
 */
package com.gambit.sdk;

import com.gambit.sdk.GambitRequest;
import com.gambit.sdk.GambitSDKService;
import com.gambit.sdk.GambitWebsocketEndpoint;
import com.gambit.sdk.message.GambitMessage;
import java.io.IOException;
import java.net.URI;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.TimeZone;
import javax.websocket.CloseReason;
import javax.websocket.MessageHandler;
import javax.websocket.PongMessage;
import javax.xml.bind.DatatypeConverter;
import org.json.JSONObject;

public class GambitPushService {
    protected final Builder mBuilder;
    protected String mPayload;
    protected String mSignature;
    protected GambitMessageListener mListener;
    protected MessageHandler.Whole<String> mMessageHandler = new MessageHandler.Whole<String>(){

        public void onMessage(String message) {
            GambitMessage messageObject = new GambitMessage(message);
            if (GambitPushService.this.mListener != null) {
                if (messageObject.isValid() && messageObject.getMessageId() != null) {
                    String ackPacket = GambitPushService.this.getAckPacketForMessage(messageObject);
                    GambitPushService.this.mEndpoint.getSession().getAsyncRemote().sendText(ackPacket);
                }
                GambitPushService.this.mListener.onGambitMessage(GambitPushService.this.mBuilder, messageObject);
            }
        }
    };
    protected MessageHandler.Whole<PongMessage> mPingPongHandler = new MessageHandler.Whole<PongMessage>(){

        public void onMessage(PongMessage message) {
        }
    };
    protected GambitWebsocketEndpoint mEndpoint;

    public GambitPushService(Builder builder) throws IOException {
        this.mBuilder = builder;
        JSONObject payload = new JSONObject();
        payload.put("access_key", (Object)builder.getAccessKey());
        payload.put("client_salt", (Object)builder.getClientSalt());
        if (builder.getNamespace() != null) {
            payload.put("namespace", (Object)builder.getNamespace());
        }
        TimeZone tz = TimeZone.getTimeZone("UTC");
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd'T'HH:mmZ");
        df.setTimeZone(tz);
        String timestamp = df.format(new Date());
        payload.put("timestamp", (Object)timestamp);
        if (builder.getAttributes() != null) {
            payload.put("attributes", builder.getAttributes());
        }
        String payloadData = payload.toString();
        try {
            this.mSignature = GambitRequest.getHmac(payloadData, builder.getClientSecret());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.mPayload = DatatypeConverter.printBase64Binary((byte[])payloadData.getBytes());
        this.start();
    }

    public void setListener(GambitMessageListener listener) {
        this.mListener = listener;
    }

    protected String getAckPacketForMessage(GambitMessage messageObject) {
        JSONObject payload = new JSONObject();
        payload.put("event", (Object)"message-received");
        payload.put("message_id", (Object)messageObject.getMessageId());
        return payload.toString();
    }

    protected void start() throws IOException {
        String hostname = GambitSDKService.getInstance().getEndpointHostname();
        if (hostname == null) {
            throw new IOException("Invalid API endpoint.");
        }
        StringBuilder builder = new StringBuilder();
        builder.append("wss://");
        builder.append(hostname);
        builder.append(":443");
        builder.append("/push");
        this.mEndpoint = new GambitWebsocketEndpoint(URI.create(builder.toString()), this.mPayload, this.mSignature, this.mMessageHandler, this.mPingPongHandler);
    }

    public void shutdown() {
        try {
            if (this.mEndpoint.isRunning()) {
                this.mEndpoint.getSession().close(new CloseReason((CloseReason.CloseCode)CloseReason.CloseCodes.NORMAL_CLOSURE, "shutting down"));
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static class Builder {
        protected final String mClientSalt;
        protected final String mClientSecret;
        protected final String mAccessKey;
        protected LinkedHashMap<String, Object> mAttributes;
        protected String mNamespace;
        protected String mTopicDescription;

        public Builder(String access_key, String client_salt, String client_secret, String topicDescription) {
            this.mAccessKey = access_key;
            this.mClientSalt = client_salt;
            this.mClientSecret = client_secret;
            this.mTopicDescription = topicDescription;
        }

        public Builder setNamespace(String namespace) {
            this.mNamespace = namespace;
            return this;
        }

        public String getNamespace() {
            return this.mNamespace;
        }

        public Builder setAttributes(LinkedHashMap<String, Object> attributes) {
            this.mAttributes = attributes;
            return this;
        }

        public LinkedHashMap<String, Object> getAttributes() {
            return this.mAttributes;
        }

        public String getAccessKey() {
            return this.mAccessKey;
        }

        public String getClientSalt() {
            return this.mClientSalt;
        }

        public String getClientSecret() {
            return this.mClientSecret;
        }

        public String getTopicDescription() {
            return this.mTopicDescription;
        }

        public GambitPushService build() throws Exception {
            this.validate();
            return new GambitPushService(this);
        }

        protected void validate() throws Exception {
            if (this.mAttributes == null || this.mAttributes.isEmpty()) {
                throw new Exception("Missing mandatory parameter of Builder: attributes");
            }
            if (this.mNamespace == null || this.mNamespace.isEmpty()) {
                throw new Exception("Missing mandatory parameter of Builder: namespace");
            }
        }
    }

    public static interface GambitMessageListener {
        public void onGambitMessage(Builder var1, GambitMessage var2);
    }
}

