/*
 * Decompiled with CFR 0.152.
 */
package com.gambit.sdk.request;

import com.gambit.sdk.GambitRequest;
import com.gambit.sdk.GambitResponse;
import com.gambit.sdk.exceptions.CogsException;
import com.gambit.sdk.response.GambitResponseEvent;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import org.json.JSONObject;

public class GambitRequestEvent
extends GambitRequest {
    protected static final String endpoint = "event";
    protected String mBody;
    protected final String mClientSalt;
    protected final String mClientSecret;
    protected final String mAccessKey;
    protected String mTimestamp;
    protected String mEventName;
    protected ArrayList<String> mTags;
    protected LinkedHashMap<String, Object> mAttributes;
    protected int mCampaignId;
    protected String mNamespace;
    protected String mDebugDirective;
    protected boolean mForwardAsMessage = false;

    protected GambitRequestEvent(Builder builder) {
        this.mAccessKey = builder.getAccessKey();
        this.mClientSalt = builder.getClientSalt();
        this.mClientSecret = builder.getClientSecret();
        this.mTimestamp = builder.getTimestamp();
        this.mEventName = builder.getEventName();
        this.mTags = builder.getTags();
        this.mAttributes = builder.getAttributes();
        this.mCampaignId = builder.getCampaignId();
        this.mNamespace = builder.getNamespace();
        this.mDebugDirective = builder.getDebugDirective();
        this.mForwardAsMessage = builder.isForwardAsMessage();
    }

    @Override
    protected String getMethod() {
        return "POST";
    }

    @Override
    protected URL getUrl() throws IOException {
        StringBuilder builder = new StringBuilder();
        builder.append(this.getBaseUrl());
        builder.append(endpoint);
        URL url = null;
        try {
            url = new URL(builder.toString());
        }
        catch (MalformedURLException ex) {
            throw new CogsException("Invalid URL for Cogs event request.", ex);
        }
        return url;
    }

    @Override
    protected String getBody() {
        if (this.mBody == null) {
            JSONObject json = new JSONObject();
            json.put("client_salt", (Object)this.mClientSalt);
            json.put("access_key", (Object)this.mAccessKey);
            json.put("event_name", (Object)this.mEventName);
            json.put("timestamp", (Object)this.mTimestamp);
            json.put("namespace", (Object)this.mNamespace);
            json.put("attributes", this.mAttributes);
            if (this.mCampaignId > 0) {
                json.put("campaign_id", this.mCampaignId);
            }
            if (this.mTags != null && !this.mTags.isEmpty()) {
                json.put("tags", this.mTags);
            }
            if (this.mDebugDirective != null && !this.mDebugDirective.isEmpty()) {
                json.put("debug_directive", (Object)this.mDebugDirective);
            }
            if (this.mForwardAsMessage) {
                json.put("forward_as_message", true);
            }
            this.mBody = json.toString();
        }
        return this.mBody;
    }

    @Override
    protected void setRequestParams(HttpURLConnection connection) {
        try {
            connection.setRequestProperty("Payload-HMAC", GambitRequestEvent.getHmac(this.getBody(), this.mClientSecret));
        }
        catch (Exception ex) {
            throw new CogsException("Invalid parameters for Cogs event request.", ex);
        }
    }

    @Override
    protected GambitResponse getResponse(String response, int code) {
        return new GambitResponseEvent(response, code);
    }

    public String getTimestamp() {
        return this.mTimestamp;
    }

    public String getAccessKey() {
        return this.mAccessKey;
    }

    public String getClientSalt() {
        return this.mClientSalt;
    }

    public String getClientSecret() {
        return this.mClientSecret;
    }

    public String getEventName() {
        return this.mEventName;
    }

    public int getCampaignId() {
        return this.mCampaignId;
    }

    public String getNamespace() {
        return this.mNamespace;
    }

    public LinkedHashMap<String, Object> getAttributes() {
        return this.mAttributes;
    }

    public ArrayList<String> getTags() {
        return this.mTags;
    }

    public String getDebugDirective() {
        return this.mDebugDirective;
    }

    public boolean isForwardAsMessage() {
        return this.mForwardAsMessage;
    }

    public static class Builder {
        protected final String mClientSalt;
        protected final String mClientSecret;
        protected final String mAccessKey;
        protected String mEventName;
        protected String mTimestamp;
        protected ArrayList<String> mTags;
        protected LinkedHashMap<String, Object> mAttributes;
        protected int mCampaignId = 0;
        protected String mNamespace;
        protected String mDebugDirective;
        protected boolean mForwardAsMessage = false;

        public Builder(String access_key, String client_salt, String client_secret) {
            this.mAccessKey = access_key;
            this.mClientSalt = client_salt;
            this.mClientSecret = client_secret;
        }

        public String getTimestamp() {
            return this.mTimestamp;
        }

        public Builder setTimestamp(String timestamp) {
            this.mTimestamp = timestamp;
            return this;
        }

        public Builder setEventName(String event_name) {
            this.mEventName = event_name;
            return this;
        }

        public String getEventName() {
            return this.mEventName;
        }

        public Builder setCampaignId(int campaign_id) {
            this.mCampaignId = campaign_id;
            return this;
        }

        public int getCampaignId() {
            return this.mCampaignId;
        }

        public Builder setNamespace(String namespace) {
            this.mNamespace = namespace;
            return this;
        }

        public String getNamespace() {
            return this.mNamespace;
        }

        public Builder setAttributes(LinkedHashMap<String, Object> attributes) {
            this.mAttributes = attributes;
            return this;
        }

        public LinkedHashMap<String, Object> getAttributes() {
            return this.mAttributes;
        }

        public Builder setTags(ArrayList<String> tags) {
            this.mTags = tags;
            return this;
        }

        public ArrayList<String> getTags() {
            return this.mTags;
        }

        public String getAccessKey() {
            return this.mAccessKey;
        }

        public String getClientSalt() {
            return this.mClientSalt;
        }

        public String getClientSecret() {
            return this.mClientSecret;
        }

        public String getDebugDirective() {
            return this.mDebugDirective;
        }

        public Builder setDebugDirective(String debugDirective) {
            this.mDebugDirective = debugDirective;
            return this;
        }

        public Builder setForwardAsMessage(boolean flag) {
            this.mForwardAsMessage = flag;
            return this;
        }

        public boolean isForwardAsMessage() {
            return this.mForwardAsMessage;
        }

        public GambitRequestEvent build() throws Exception {
            this.validate();
            return new GambitRequestEvent(this);
        }

        protected void validate() throws Exception {
            if (this.mEventName == null || this.mEventName.isEmpty()) {
                throw new Exception("Missing mandatory parameter of Builder: event_name");
            }
            if (this.mAttributes == null || this.mAttributes.isEmpty()) {
                throw new Exception("Missing mandatory parameter of Builder: attributes");
            }
            if (this.mNamespace == null || this.mNamespace.isEmpty()) {
                throw new Exception("Missing mandatory parameter of Builder: namespace");
            }
            if (this.mTimestamp == null || this.mTimestamp.isEmpty()) {
                throw new Exception("Missing mandatory parameter of Builder: timestamp");
            }
        }
    }
}

