/*
 * Decompiled with CFR 0.152.
 */
package com.gambit.sdk;

import com.gambit.sdk.GambitResponse;
import com.gambit.sdk.GambitSDKService;
import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.util.concurrent.Callable;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import javax.xml.bind.DatatypeConverter;

public abstract class GambitRequest
implements Callable<GambitResponse> {
    protected static final String API_USER_AGENT = "GambitTools SDK for Java SE";

    public static String getHmac(String content, String key) throws NoSuchAlgorithmException, UnsupportedEncodingException, InvalidKeyException {
        Mac sha256_HMAC = Mac.getInstance("HmacSHA256");
        byte[] key_hex = DatatypeConverter.parseHexBinary((String)key);
        SecretKeySpec secret_key = new SecretKeySpec(key_hex, "HmacSHA256");
        sha256_HMAC.init(secret_key);
        byte[] raw = sha256_HMAC.doFinal(content.getBytes("UTF-8"));
        String hmac = DatatypeConverter.printHexBinary((byte[])raw);
        return hmac;
    }

    protected String getBaseUrl() throws IOException {
        String hostname = GambitSDKService.getInstance().getEndpointHostname();
        if (hostname == null) {
            throw new IOException("Invalid API endpoint.");
        }
        StringBuilder builder = new StringBuilder();
        builder.append("https://");
        builder.append(hostname);
        builder.append("/");
        return builder.toString();
    }

    @Override
    public GambitResponse call() throws IOException {
        int responseCode;
        URL url = this.getUrl();
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        connection.setRequestMethod(this.getMethod());
        connection.setRequestProperty("User-Agent", API_USER_AGENT);
        connection.setRequestProperty("Content-Type", "application/json");
        connection.setRequestProperty("Accept", "application/json");
        this.setRequestParams(connection);
        String body = this.getBody();
        if (body.length() > 0) {
            connection.setRequestProperty("Content-Length", Integer.toString(body.getBytes().length));
            connection.setDoOutput(true);
            DataOutputStream wr = new DataOutputStream(connection.getOutputStream());
            wr.writeBytes(body);
            wr.flush();
            wr.close();
        }
        StringBuilder response = new StringBuilder();
        try {
            String inputLine;
            responseCode = connection.getResponseCode();
            BufferedReader in = new BufferedReader(new InputStreamReader(connection.getInputStream()));
            while ((inputLine = in.readLine()) != null) {
                response.append(inputLine);
            }
            in.close();
        }
        catch (IOException e) {
            String inputLine;
            responseCode = 400;
            BufferedReader in = new BufferedReader(new InputStreamReader(connection.getErrorStream()));
            while ((inputLine = in.readLine()) != null) {
                response.append(inputLine);
            }
            in.close();
        }
        return this.getResponse(response.toString(), responseCode);
    }

    protected abstract String getMethod();

    protected abstract URL getUrl() throws IOException;

    protected abstract String getBody();

    protected abstract void setRequestParams(HttpURLConnection var1);

    protected abstract GambitResponse getResponse(String var1, int var2);
}

