package io.codingpassion.spring.jwt;

import java.security.Key;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.Date;

import io.jsonwebtoken.Jwts;
import io.jsonwebtoken.SignatureAlgorithm;

public class TokenIssuer {

    private Key key;

    private String issuer;

    public TokenIssuer(Key key, String issuer) {
        this.key = key;
        this.issuer = issuer;
    }

    public String issueToken(UserMetadata userMetadata) {
        LocalDateTime currentDateTime = LocalDateTime.now();
        LocalDateTime expirationDateTime = currentDateTime.plusMinutes(userMetadata.getExpirationTimeInMinutes());

        return Jwts.builder()
            .setSubject(userMetadata.getUsername())
            .setIssuer(issuer)
            .setIssuedAt(Date.from(currentDateTime.atZone(ZoneId.systemDefault()).toInstant()))
            .setExpiration(Date.from(expirationDateTime.atZone(ZoneId.systemDefault()).toInstant()))
            .signWith(SignatureAlgorithm.HS512, key)
             .compact();
    }
}
