/*
 * Decompiled with CFR 0.152.
 */
package io.codingpassion.spring.jwt.authenticator;

import io.codingpassion.spring.jwt.TokenIssuer;
import io.codingpassion.spring.jwt.TokenNotValidException;
import io.codingpassion.spring.jwt.TokenValidator;
import io.codingpassion.spring.jwt.UserMetadata;
import io.codingpassion.spring.jwt.ValidatedToken;
import io.codingpassion.spring.jwt.authenticator.Authenticator;
import io.codingpassion.spring.jwt.authenticator.UserMetadataRepository;
import io.codingpassion.spring.jwt.authenticator.UsernameAndPassword;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Api(value="/api/user", description="User resource prepared to login users to the system.")
@RestController
@RequestMapping(value={"/api/user"})
public class UserResource {
    private static final Logger log = LoggerFactory.getLogger(UserResource.class);
    @Autowired
    private TokenIssuer tokenIssuer;
    @Autowired
    private Authenticator authenticator;
    @Autowired
    private TokenValidator tokenValidator;
    @Autowired
    private UserMetadataRepository userMetadataRepository;

    @ApiOperation(value="Login/authenticate user with provided username and password to the system.")
    @ApiResponses(value={@ApiResponse(code=200, message="When an user has been successfully logged/authenticated to the system."), @ApiResponse(code=401, message="When unable to authenticate (wrong username or password).")})
    @PostMapping(value={"/login"})
    public ResponseEntity login(@RequestBody UsernameAndPassword usernameAndPassword) {
        UserMetadata authenticatedUserMetadata = this.authenticator.authenticate(usernameAndPassword);
        String token = this.tokenIssuer.issueToken(authenticatedUserMetadata);
        return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().header("Authorization", new String[]{token})).build();
    }

    @ApiOperation(value="Returns information about logged user by given token.")
    @ApiResponses(value={@ApiResponse(code=200, message="When given token is valid and user exists."), @ApiResponse(code=404, message="When unable to find an user by given token."), @ApiResponse(code=400, message="When given token is invalid.")})
    @PostMapping(value={"/info"})
    public ResponseEntity info(@RequestBody String token) {
        try {
            ValidatedToken validatedToken = this.tokenValidator.validate(token);
            Optional<UserMetadata> user = this.userMetadataRepository.findByUsername(validatedToken.getSubject());
            return user.map(ResponseEntity::ok).orElseGet(() -> ResponseEntity.notFound().build());
        }
        catch (TokenNotValidException e) {
            return ResponseEntity.status((HttpStatus)HttpStatus.BAD_REQUEST).build();
        }
    }
}

