/*
 * Decompiled with CFR 0.152.
 */
package io.codingpassion.spring.jwt.authenticator;

import io.codingpassion.spring.jwt.TokenNotValidException;
import io.codingpassion.spring.jwt.TokenValidator;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Api(value="/api/token", description="Token resource prepared to operate on the JWT token.")
@RestController
@RequestMapping(value={"/api/token"})
public class TokenResource {
    private static final Logger log = LoggerFactory.getLogger(TokenResource.class);
    @Autowired
    private TokenValidator tokenValidator;

    @ApiOperation(value="Validates given token, checks if token is valid and can be used to perform requests.")
    @ApiResponses(value={@ApiResponse(code=200, message="When given token is valid."), @ApiResponse(code=401, message="When given token is invalid.")})
    @PostMapping(value={"/validate"})
    public ResponseEntity validate(@PathVariable String token) {
        try {
            this.tokenValidator.validate(token);
            return ResponseEntity.ok().build();
        }
        catch (TokenNotValidException e) {
            return ResponseEntity.status((HttpStatus)HttpStatus.UNAUTHORIZED).build();
        }
    }
}

