/*
 * Decompiled with CFR 0.152.
 */
package io.codingpassion.spring.jwt.authenticator;

import io.codingpassion.spring.jwt.TokenIssuer;
import io.codingpassion.spring.jwt.authenticator.JwtSecurityProperties;
import io.codingpassion.spring.jwt.authenticator.SimpleUserMetadataRepository;
import io.codingpassion.spring.jwt.authenticator.UserMetadataRepository;
import io.jsonwebtoken.SignatureAlgorithm;
import java.security.Key;
import javax.crypto.spec.SecretKeySpec;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;

@Configuration
@ComponentScan(value={"io.codingpassion.spring.jwt.authenticator"})
@ConditionalOnClass
@EnableConfigurationProperties(value={JwtSecurityProperties.class})
public class JwtSecurityAuthenticatorAutoConfiguration {
    @Autowired
    private JwtSecurityProperties jwtSecurityProperties;

    @Bean
    public TokenIssuer tokenIssuer() {
        SecretKeySpec key = new SecretKeySpec(this.jwtSecurityProperties.getTokenKey().getBytes(), SignatureAlgorithm.HS256.getJcaName());
        return new TokenIssuer((Key)key, this.jwtSecurityProperties.getIssuer());
    }

    @Bean
    @ConditionalOnMissingBean(value={UserMetadataRepository.class})
    public UserMetadataRepository userRepository() {
        return new SimpleUserMetadataRepository();
    }
}

