/*
 * Decompiled with CFR 0.152.
 */
package io.codingpassion.spring.jwt.authenticator;

import io.codingpassion.spring.jwt.UserMetadata;
import io.codingpassion.spring.jwt.authenticator.AuthenticationException;
import io.codingpassion.spring.jwt.authenticator.UserMetadataRepository;
import io.codingpassion.spring.jwt.authenticator.UsernameAndPassword;
import java.text.MessageFormat;
import java.util.Optional;
import org.apache.commons.codec.digest.DigestUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class Authenticator {
    private static final Logger log = LoggerFactory.getLogger(Authenticator.class);
    private static final String AUTHENTICATION_ERROR_MESSAGE = "Unable to authenticate user = {0} with given password. Login or password is incorrect.";
    @Autowired
    private UserMetadataRepository userMetadataRepository;

    public UserMetadata authenticate(UsernameAndPassword usernameAndPassword) {
        log.info("Authenticating user = {}.", (Object)usernameAndPassword.getUsername());
        String hashedPassword = DigestUtils.sha512Hex((String)usernameAndPassword.getPassword());
        Optional<UserMetadata> user = this.userMetadataRepository.findByUsernameAndPassword(usernameAndPassword.getUsername(), hashedPassword);
        if (user.isPresent()) {
            log.info("Authentication successful for user = {}.", (Object)usernameAndPassword.getUsername());
            return user.get();
        }
        log.warn("Unable to authenticate user = {}. Probable wrong login or password!", (Object)usernameAndPassword.getUsername());
        throw new AuthenticationException(MessageFormat.format(AUTHENTICATION_ERROR_MESSAGE, usernameAndPassword.getUsername()));
    }
}

