package io.codingpassion.spring.jwt.authenticator;

import java.security.Key;
import javax.crypto.spec.SecretKeySpec;

import io.codingpassion.spring.jwt.TokenIssuer;
import io.jsonwebtoken.SignatureAlgorithm;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;

@Configuration
@ComponentScan("io.codingpassion.spring.jwt.authenticator")
@ConditionalOnClass
@EnableConfigurationProperties({JwtSecurityProperties.class})
public class JwtSecurityAuthenticatorAutoConfiguration {

    @Autowired
    private JwtSecurityProperties jwtSecurityProperties;

    @Bean
    public TokenIssuer tokenIssuer() {
        Key key = new SecretKeySpec(jwtSecurityProperties.getTokenKey().getBytes(), SignatureAlgorithm.HS256.getJcaName());
        return new TokenIssuer(key, jwtSecurityProperties.getIssuer());
    }

    @Bean
    @ConditionalOnMissingBean(UserMetadataRepository.class)
    public UserMetadataRepository userRepository() {
        return new SimpleUserMetadataRepository();
    }
}
