package io.codingpassion.spring.jwt.authenticator;

import java.text.MessageFormat;
import java.util.Optional;

import io.codingpassion.spring.jwt.UserMetadata;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.codec.digest.DigestUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Slf4j
@Component
public class Authenticator {

    private static final String AUTHENTICATION_ERROR_MESSAGE = "Unable to authenticate user = {0} with given password. Login or password is incorrect.";

    @Autowired
    private UserMetadataRepository userMetadataRepository;

    public UserMetadata authenticate(UsernameAndPassword usernameAndPassword) {
        log.info("Authenticating user = {}.", usernameAndPassword.getUsername());

        String hashedPassword = DigestUtils.sha512Hex(usernameAndPassword.getPassword());

        Optional<UserMetadata> user = userMetadataRepository.findByUsernameAndPassword(usernameAndPassword.getUsername(), hashedPassword);

        if (user.isPresent()) {
            log.info("Authentication successful for user = {}.", usernameAndPassword.getUsername());
            return user.get();
        } else {
            log.warn("Unable to authenticate user = {}. Probable wrong login or password!", usernameAndPassword.getUsername());
            throw new AuthenticationException(MessageFormat.format(AUTHENTICATION_ERROR_MESSAGE, usernameAndPassword.getUsername()));
        }
    }
}
