/*
 * Decompiled with CFR 0.152.
 */
package io.codeworth.panelmatic.util.customizers;

import io.codeworth.panelmatic.PanelMaticComponentCustomizer;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.util.Map;
import java.util.WeakHashMap;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JTable;
import javax.swing.text.JTextComponent;

public class ColorOnFocusCustomizer
implements PanelMaticComponentCustomizer {
    private static final Color DEFAULT_HIGHLIGHT_COLOR = new Color(255, 255, 127);
    private Color highlightColor;
    private Map<Component, ComponentState> prevColorMap = new WeakHashMap<Component, ComponentState>();
    private final FocusListener fl = new FocusListener(){

        @Override
        public void focusGained(FocusEvent e) {
            JComponent comp = (JComponent)e.getComponent();
            ColorOnFocusCustomizer.this.prevColorMap.put(comp, new ComponentState(comp.getBackground(), comp.isOpaque()));
            comp.setBackground(ColorOnFocusCustomizer.this.highlightColor);
            comp.repaint();
        }

        @Override
        public void focusLost(FocusEvent e) {
            JComponent comp = (JComponent)e.getComponent();
            ComponentState state = ColorOnFocusCustomizer.this.prevColorMap.get(comp);
            if (state != null) {
                comp.setBackground(state.bg);
                comp.setOpaque(state.opaque);
                ColorOnFocusCustomizer.this.prevColorMap.remove(comp);
                comp.repaint();
            }
        }
    };

    public ColorOnFocusCustomizer() {
        this(DEFAULT_HIGHLIGHT_COLOR);
    }

    public ColorOnFocusCustomizer(Color highlightColor) {
        this.highlightColor = highlightColor;
    }

    @Override
    public JComponent customize(String l, JComponent jc) {
        if (jc instanceof JTextComponent || jc instanceof JList || jc instanceof JTable) {
            if (!this.prevColorMap.containsKey(jc)) {
                jc.addFocusListener(this.fl);
                this.prevColorMap.put(jc, null);
            }
        } else {
            for (Component c : jc.getComponents()) {
                if (!(c instanceof JComponent)) continue;
                this.customize(l, (JComponent)c);
            }
        }
        return jc;
    }

    private static class ComponentState {
        Color bg;
        boolean opaque;

        public ComponentState(Color bg, boolean opaque) {
            this.bg = bg;
            this.opaque = opaque;
        }
    }
}

