/*
 * Decompiled with CFR 0.152.
 */
package io.codeworth.panelmatic.util.customizers;

import io.codeworth.panelmatic.PanelMaticComponentCustomizer;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JSlider;
import javax.swing.JToggleButton;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.JTextComponent;

public class ChangeDetectorCustomizer
implements PanelMaticComponentCustomizer {
    private final List<Listener> listeners = new ArrayList<Listener>();
    private boolean fireingInProgress = false;
    private ActionListener actionListener = null;
    private DocumentListener documentListener = null;
    private ChangeListener changeListener = null;

    public ChangeDetectorCustomizer() {
    }

    public ChangeDetectorCustomizer(Listener l) {
        this.listeners.add(l);
    }

    public void fireChangeEvent(Object originalEvent) {
        try {
            this.fireingInProgress = true;
            this.listeners.forEach(l -> l.changeMade(this, originalEvent));
        }
        finally {
            this.fireingInProgress = false;
        }
    }

    public void addListener(Listener l) {
        if (this.fireingInProgress) {
            EventQueue.invokeLater(new AddCommand(l));
        } else {
            this.listeners.add(l);
        }
    }

    public void removeListener(Listener l) {
        if (this.fireingInProgress) {
            EventQueue.invokeLater(new RemoveCommand(l));
        } else {
            this.listeners.remove(l);
        }
    }

    public ActionListener getActionListener() {
        if (this.actionListener == null) {
            this.actionListener = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ChangeDetectorCustomizer.this.fireChangeEvent(e);
                }
            };
        }
        return this.actionListener;
    }

    public DocumentListener getDocumentListener() {
        if (this.documentListener == null) {
            this.documentListener = new DocumentListener(){

                @Override
                public void insertUpdate(DocumentEvent e) {
                    ChangeDetectorCustomizer.this.fireChangeEvent(e);
                }

                @Override
                public void removeUpdate(DocumentEvent e) {
                    ChangeDetectorCustomizer.this.fireChangeEvent(e);
                }

                @Override
                public void changedUpdate(DocumentEvent e) {
                    ChangeDetectorCustomizer.this.fireChangeEvent(e);
                }
            };
        }
        return this.documentListener;
    }

    public ChangeListener getChangeListener() {
        if (this.changeListener == null) {
            this.changeListener = e -> this.fireChangeEvent(e);
        }
        return this.changeListener;
    }

    @Override
    public JComponent customize(String labelText, JComponent aComp) {
        if (aComp instanceof JTextComponent) {
            ((JTextComponent)aComp).getDocument().addDocumentListener(this.getDocumentListener());
        } else if (aComp instanceof JToggleButton) {
            ((JToggleButton)aComp).addActionListener(this.getActionListener());
        } else if (aComp instanceof JComboBox) {
            ((JComboBox)aComp).addActionListener(this.getActionListener());
        } else if (aComp instanceof JSlider) {
            ((JSlider)aComp).addChangeListener(this.getChangeListener());
        } else {
            for (Component c : aComp.getComponents()) {
                if (!(c instanceof JComponent)) continue;
                this.customize(labelText, (JComponent)c);
            }
        }
        return aComp;
    }

    private class RemoveCommand
    implements Runnable {
        Listener l;

        public RemoveCommand(Listener l) {
            this.l = l;
        }

        @Override
        public void run() {
            ChangeDetectorCustomizer.this.listeners.remove(this.l);
        }
    }

    private class AddCommand
    implements Runnable {
        Listener l;

        public AddCommand(Listener l) {
            this.l = l;
        }

        @Override
        public void run() {
            ChangeDetectorCustomizer.this.listeners.add(this.l);
        }
    }

    public static interface Listener {
        public void changeMade(ChangeDetectorCustomizer var1, Object var2);
    }
}

