/*
 * Decompiled with CFR 0.152.
 */
package io.codeworth.panelmatic.util;

import io.codeworth.panelmatic.PanelMatic;
import io.codeworth.panelmatic.PanelPostProcessor;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;

public class PanelPostProcessors {
    public static PanelPostProcessor addBorder(Border b) {
        return product -> {
            product.setBorder(b);
            return product;
        };
    }

    public static PanelPostProcessor addBorder(String title) {
        String effectiveTitle = PanelMatic.getLocalizationBundle() != null ? PanelMatic.getLocalizationBundle().getString(title) : title;
        return PanelPostProcessors.addBorder(new TitledBorder(effectiveTitle));
    }

    public static PanelPostProcessor wrapInScrollPane(final Boolean hScroll, final Boolean vScroll) {
        return new PanelPostProcessor(){

            @Override
            public JComponent process(JComponent product) {
                JScrollPane p = new JScrollPane(product);
                if (vScroll != null) {
                    p.setVerticalScrollBarPolicy(vScroll != false ? 22 : 21);
                }
                if (hScroll != null) {
                    p.setHorizontalScrollBarPolicy(vScroll != false ? 32 : 31);
                }
                return p;
            }
        };
    }

    public static PanelPostProcessor wrapInScrollPane(Boolean vScroll) {
        return PanelPostProcessors.wrapInScrollPane(Boolean.FALSE, vScroll);
    }

    public static PanelPostProcessor wrapInScrollPane() {
        return PanelPostProcessors.wrapInScrollPane(Boolean.TRUE);
    }
}

