/*
 * Decompiled with CFR 0.152.
 */
package io.codeworth.panelmatic.util;

import io.codeworth.panelmatic.PanelMatic;
import java.awt.GridLayout;
import java.util.ArrayList;
import java.util.Arrays;
import javax.swing.Box;
import javax.swing.JComponent;
import javax.swing.JPanel;

public class Groupings {
    public static JComponent lineGroup(JComponent ... comps) {
        JComponent val = Groupings.commonCases(comps);
        if (val == null) {
            val = Groupings.lineGroup(Arrays.asList(comps));
        }
        return val;
    }

    public static JComponent lineGroup(Iterable<? extends JComponent> cmpItr) {
        Box val = new Box(2);
        val.setComponentOrientation(PanelMatic.getComponentOrientation());
        for (JComponent jComponent : cmpItr) {
            val.add(jComponent);
        }
        return val;
    }

    public static JComponent pageGroup(JComponent ... comps) {
        JComponent val = Groupings.commonCases(comps);
        if (val == null) {
            val = Groupings.pageGroup(Arrays.asList(comps));
        }
        return val;
    }

    public static JComponent pageGroup(Iterable<? extends JComponent> cmpItr) {
        Box val = new Box(3);
        val.setComponentOrientation(PanelMatic.getComponentOrientation());
        for (JComponent jComponent : cmpItr) {
            val.add(jComponent);
        }
        return val;
    }

    public static JComponent gridGroup(JComponent ... comps) {
        JComponent val = Groupings.commonCases(comps);
        if (val == null) {
            int gridEdgeSize = (int)Math.ceil(Math.sqrt(comps.length));
            val = new JPanel(new GridLayout(gridEdgeSize, gridEdgeSize));
            val.setComponentOrientation(PanelMatic.getComponentOrientation());
            for (JComponent c : comps) {
                val.add(c);
            }
        }
        return val;
    }

    public static JComponent gridGroup(Iterable<? extends JComponent> cmpItr) {
        ArrayList<JComponent> arr = new ArrayList<JComponent>();
        for (JComponent jComponent : cmpItr) {
            arr.add(jComponent);
        }
        return Groupings.pageGroup(arr.toArray(new JComponent[arr.size()]));
    }

    private static JComponent commonCases(JComponent ... comps) {
        if (comps.length == 0) {
            return new JPanel();
        }
        if (comps.length == 1) {
            return comps[0];
        }
        return null;
    }
}

